/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao.directive;

import java.util.Map;
import org.eclipse.sensinact.gateway.util.CastUtils;

public abstract class Directive {
    protected String table;

    protected Directive(String table) {
        this.table = table;
    }

    protected void buildEqualityDirective(StringBuilder builder, Map.Entry<String, Object> entry) {
        this.buildEqualityDirective(builder, entry.getKey(), entry.getValue());
    }

    protected void buildEqualityDirective(StringBuilder builder, String column, Object value) {
        builder.append(this.getColumnName(column));
        builder.append("=");
        builder.append(this.getStringValue(value));
    }

    protected String getColumnName(String column) {
        String[] columnElements = column.split(".");
        if (columnElements.length == 2 && this.table.equals(columnElements[0])) {
            return column;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.table);
        builder.append(".");
        builder.append(column);
        return builder.toString();
    }

    protected String getStringValue(Object object) {
        StringBuilder builder = new StringBuilder();
        if (object != null && object.getClass() == String.class) {
            builder.append("'");
            builder.append((String)object);
            builder.append("'");
        } else {
            builder.append((String)CastUtils.cast(String.class, (Object)object));
        }
        return builder.toString();
    }
}

