/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.endpoint;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.xmlns.rsa.v1_0.ArrayType;
import org.osgi.xmlns.rsa.v1_0.ObjectFactory;
import org.osgi.xmlns.rsa.v1_0.PropertyType;
import org.osgi.xmlns.rsa.v1_0.ValueType;
import org.osgi.xmlns.rsa.v1_0.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

class PropertiesMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesMapper.class);

    PropertiesMapper() {
    }

    public Map<String, Object> toProps(List<PropertyType> properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyType prop : properties) {
            map.put(prop.getName(), this.getValue(prop));
        }
        return map;
    }

    private Object getValue(PropertyType prop) {
        Object value = null;
        String type = PropertiesMapper.getTypeName(prop);
        Object content = this.getFirstNonText(prop.getContent());
        if (content instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)content;
            if (el.getDeclaredType() == ArrayType.class) {
                String elName = el.getName().getLocalPart();
                ArrayType inValue = (ArrayType)el.getValue();
                if ("array".equals(elName)) {
                    value = this.getArray(inValue, type);
                } else if ("set".equals(elName)) {
                    value = this.handleCollection(inValue, new HashSet(), type);
                } else if ("list".equals(elName)) {
                    value = this.handleCollection(inValue, new ArrayList(), type);
                }
            } else if (el.getDeclaredType() == XmlType.class) {
                value = this.readXML((XmlType)el.getValue(), type);
            }
        } else if (prop.getValue() != null) {
            value = PropertiesMapper.instantiate(type, prop.getValue());
        } else if (prop.getContent().size() > 0) {
            value = PropertiesMapper.instantiate(type, prop.getContent().get(0).toString());
        }
        return value;
    }

    private Object getFirstNonText(List<Serializable> contentList) {
        for (Serializable content : contentList) {
            if (!(content instanceof JAXBElement)) continue;
            return content;
        }
        return null;
    }

    private static String getTypeName(PropertyType prop) {
        String type = prop.getValueType();
        return type == null ? "String" : type;
    }

    private Object getArray(ArrayType arrayEl, String type) {
        List<ValueType> values = arrayEl.getValue();
        Class<Constable> cls = null;
        if ("long".equals(type)) {
            cls = Long.TYPE;
        } else if ("double".equals(type)) {
            cls = Double.TYPE;
        } else if ("float".equals(type)) {
            cls = Float.TYPE;
        } else if ("int".equals(type)) {
            cls = Integer.TYPE;
        } else if ("byte".equals(type)) {
            cls = Byte.TYPE;
        } else if ("boolean".equals(type)) {
            cls = Boolean.TYPE;
        } else if ("short".equals(type)) {
            cls = Short.TYPE;
        }
        try {
            if (cls == null) {
                cls = ClassLoader.getSystemClassLoader().loadClass("java.lang." + type);
            }
            Object array = Array.newInstance(cls, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Object val = this.getValue(values.get(i), type);
                Array.set(array, i, val);
            }
            return array;
        }
        catch (Exception e) {
            LOG.warn("Could not create array for Endpoint Description", (Throwable)e);
            return null;
        }
    }

    private Collection handleCollection(ArrayType el, Collection value, String type) {
        List<ValueType> values = el.getValue();
        for (ValueType val : values) {
            Object obj = this.getValue(val, type);
            value.add(obj);
        }
        return value;
    }

    private Object getValue(ValueType value, String type) {
        if (value.getContent().size() == 1 && value.getContent().get(0) instanceof String) {
            return PropertiesMapper.handleValue((String)((Object)value.getContent().get(0)), type);
        }
        JAXBElement valueContent = (JAXBElement)this.getFirstNonText(value.getContent());
        if (valueContent.getDeclaredType() == XmlType.class) {
            return this.readXML((XmlType)valueContent.getValue(), type);
        }
        return "";
    }

    private String readXML(XmlType el, String type) {
        if (el == null) {
            return null;
        }
        if (!"String".equals(type)) {
            LOG.warn("Embedded XML must be of type String, found: " + type);
            return null;
        }
        Node xmlContent = (Node)el.getAny();
        xmlContent.normalize();
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(xmlContent), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Object handleValue(String val, String type) {
        return PropertiesMapper.instantiate(type, val);
    }

    private static Object instantiate(String type, String value) {
        if ("String".equals(type)) {
            return value;
        }
        value = value.trim();
        String boxedType = null;
        if ("long".equals(type)) {
            boxedType = "Long";
        } else if ("double".equals(type)) {
            boxedType = "Double";
        } else if ("float".equals(type)) {
            boxedType = "Float";
        } else if ("int".equals(type)) {
            boxedType = "Integer";
        } else if ("byte".equals(type)) {
            boxedType = "Byte";
        } else if ("char".equals(type)) {
            boxedType = "Character";
        } else if ("boolean".equals(type)) {
            boxedType = "Boolean";
        } else if ("short".equals(type)) {
            boxedType = "Short";
        }
        if (boxedType == null) {
            boxedType = type;
        }
        String javaType = "java.lang." + boxedType;
        try {
            if ("Character".equals(boxedType)) {
                return Character.valueOf(value.charAt(0));
            }
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(javaType);
            Constructor<?> ctor = cls.getConstructor(String.class);
            return ctor.newInstance(value);
        }
        catch (Exception e) {
            LOG.warn("Could not create Endpoint Property of type " + type + " and value " + value);
            return null;
        }
    }

    public List<PropertyType> fromProps(Map<String, Object> m) {
        ArrayList<PropertyType> props = new ArrayList<PropertyType>();
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            PropertyType propEl = new PropertyType();
            propEl.setName(key);
            ObjectFactory factory = new ObjectFactory();
            if (val.getClass().isArray()) {
                ArrayType arrayEl = new ArrayType();
                propEl.getContent().add((Serializable)factory.createArray(arrayEl));
                for (Object o : PropertiesMapper.normalizeArray(val)) {
                    PropertiesMapper.setValueType(propEl, o);
                    ValueType valueType = new ValueType();
                    valueType.getContent().add((Serializable)((Object)o.toString()));
                    arrayEl.getValue().add(valueType);
                }
            } else if (val instanceof List) {
                ArrayType listEl = new ArrayType();
                propEl.getContent().add((Serializable)factory.createList(listEl));
                PropertiesMapper.handleCollectionValue((Collection)val, propEl, listEl);
            } else if (val instanceof Set) {
                ArrayType setEl = new ArrayType();
                propEl.getContent().add((Serializable)factory.createSet(setEl));
                PropertiesMapper.handleCollectionValue((Collection)val, propEl, setEl);
            } else if (val instanceof String || val instanceof Character || val instanceof Boolean || val instanceof Byte) {
                PropertiesMapper.setValueType(propEl, val);
                propEl.setValue(val.toString());
            } else {
                if (!(val instanceof Long) && !(val instanceof Double) && !(val instanceof Float) && !(val instanceof Integer) && !(val instanceof Short)) continue;
                PropertiesMapper.setValueType(propEl, val);
                propEl.setValue(val.toString());
            }
            props.add(propEl);
        }
        return props;
    }

    private static Object[] normalizeArray(Object val) {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        if (val instanceof int[]) {
            int[] ia;
            for (int i : ia = (int[])val) {
                l.add(Integer.valueOf(i));
            }
        } else if (val instanceof long[]) {
            long[] la;
            for (long i : la = (long[])val) {
                l.add(Long.valueOf(i));
            }
        } else if (val instanceof float[]) {
            float[] fa;
            for (float f : fa = (float[])val) {
                l.add(Float.valueOf(f));
            }
        } else if (val instanceof byte[]) {
            byte[] ba;
            for (byte b : ba = (byte[])val) {
                l.add(Byte.valueOf(b));
            }
        } else if (val instanceof boolean[]) {
            boolean[] ba;
            for (boolean b : ba = (boolean[])val) {
                l.add(Boolean.valueOf(b));
            }
        } else if (val instanceof short[]) {
            short[] sa;
            for (short s : sa = (short[])val) {
                l.add(Short.valueOf(s));
            }
        } else if (val instanceof char[]) {
            char[] ca;
            for (char c : ca = (char[])val) {
                l.add(Character.valueOf(c));
            }
        } else {
            return (Object[])val;
        }
        return l.toArray();
    }

    private static void handleCollectionValue(Collection<?> val, PropertyType propEl, ArrayType listEl) {
        for (Object o : val) {
            PropertiesMapper.setValueType(propEl, o);
            ValueType valueType = new ValueType();
            valueType.getContent().add((Serializable)((Object)o.toString()));
            listEl.getValue().add(valueType);
        }
    }

    private static void setValueType(PropertyType propEl, Object val) {
        if (val instanceof String) {
            return;
        }
        String dataType = val.getClass().getName();
        if (dataType.startsWith("java.lang.")) {
            dataType = dataType.substring("java.lang.".length());
        }
        propEl.setValueType(dataType);
    }
}

