/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback.internal;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.CallbackService;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.HttpRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.HttpResponseWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.ServletCallbackContext;

public class CallbackServlet
extends HttpServlet
implements Servlet {
    private CallbackService callbackService;
    private Mediator mediator;

    public CallbackServlet(Mediator mediator, CallbackService callbackService) {
        this.callbackService = callbackService;
        this.mediator = mediator;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    private final void doCall(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        ServletCallbackContext context = new ServletCallbackContext(this.mediator, new HttpRequestWrapper(request), new HttpResponseWrapper(response));
        try {
            if (this.callbackService != null) {
                this.callbackService.process(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.sendError(520, "Internal server error");
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doCall(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doCall(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doCall(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doCall(request, response);
    }
}

