/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal.shell;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.commands.gogo.internal.shell.ShellAccessRequest;
import org.eclipse.sensinact.gateway.commands.gogo.osgi.CommandServiceMediator;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundAccess;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.format.JSONResponseFormat;
import org.json.JSONObject;

public class ShellAccess
extends NorthboundAccess<ShellAccessRequest> {
    protected NorthboundEndpoint endpoint;

    public static void proceed(CommandServiceMediator mediator, JSONObject object) {
        try {
            ShellAccessRequest request = new ShellAccessRequest(mediator, object);
            new ShellAccess(request).proceed();
        }
        catch (IOException | InvalidCredentialException e) {
            mediator.getOutput().outputError(520, e.getMessage());
        }
    }

    public ShellAccess(ShellAccessRequest request) throws IOException, InvalidCredentialException {
        super((NorthboundRequestWrapper)request);
        this.endpoint = ((CommandServiceMediator)this.mediator).getEndpoint();
    }

    protected boolean respond(NorthboundMediator mediator, NorthboundRequestBuilder builder) throws IOException {
        JSONObject result;
        NorthboundRequest nthbndRequest = builder.build();
        if (nthbndRequest == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        AccessMethodResponse cap = this.endpoint.execute(nthbndRequest);
        String resultStr = null;
        List<String> rawList = null;
        Map<NorthboundRequestWrapper.QueryKey, List<String>> queryMap = ((ShellAccessRequest)this.request).getQueryMap();
        for (NorthboundRequestWrapper.QueryKey queryKey : queryMap.keySet()) {
            if (!"rawDescribe".equals(queryKey.name)) continue;
            rawList = queryMap.get(queryKey);
            break;
        }
        if ((result = new JSONResponseFormat().format((Object)(resultStr = rawList != null && (rawList.contains("true") || rawList.contains("True") || rawList.contains("yes") || rawList.contains("Yes")) && DescribeResponse.class.isAssignableFrom(cap.getClass()) ? ((DescribeResponse)cap).getJSON(true) : cap.getJSON()))) == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        ((CommandServiceMediator)this.mediator).getOutput().output(result, 0);
        return true;
    }

    protected void sendError(int i, String message) throws IOException {
        ((CommandServiceMediator)this.mediator).getOutput().outputError(i, message);
    }
}

