/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.datastore.sqlite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.sensinact.gateway.core.security.SecurityDataStoreService;
import org.eclipse.sensinact.gateway.datastore.api.DataStore;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreConnectionProvider;
import org.eclipse.sensinact.gateway.datastore.api.UnableToConnectToDataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.UnableToFindDataStoreException;
import org.eclipse.sensinact.gateway.datastore.jdbc.JdbcDataStoreService;
import org.eclipse.sensinact.gateway.datastore.sqlite.SQLiteConnectionProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@DataStore(provider="jdbc", sgbd="sqlite")
@Component(name="SQLiteDataStoreService", service={SecurityDataStoreService.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class SQLiteDataStoreService
extends JdbcDataStoreService
implements SecurityDataStoreService {
    public static final String PID = "SQLiteDataStoreService";
    private SQLiteConnectionProvider provider;

    @Activate
    public void start(SQLiteConfig config) throws UnableToConnectToDataStoreException, UnableToFindDataStoreException {
        this.provider = new SQLiteConnectionProvider(config.database());
    }

    protected DataStoreConnectionProvider<Connection> getDataBaseConnectionProvider() {
        return this.provider;
    }

    @Deactivate
    public void stop() {
        if (this.provider != null) {
            this.provider.stop();
            while (this.provider.getCount() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    ex.printStackTrace();
                }
            }
        }
        this.provider = null;
    }

    public long getLastInsertedId(Statement statement) throws SQLException {
        ResultSet rs = null;
        long lastID = -1L;
        rs = statement.executeQuery("SELECT last_insert_rowid() AS LASTID;");
        if (rs.next()) {
            lastID = rs.getLong(1);
        }
        return lastID;
    }

    @ObjectClassDefinition(pid={"SQLiteDataStoreService"})
    public static @interface SQLiteConfig {
        @AttributeDefinition(required=true)
        public String database();
    }
}

