/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.mqtt.inst.internal;

import java.util.Map;
import org.eclipse.sensinact.gateway.agent.mqtt.generic.internal.GenericMqttAgent;
import org.eclipse.sensinact.gateway.agent.mqtt.inst.internal.SnaEventEventHandler;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="mqtt.agent.broker", configurationPolicy=ConfigurationPolicy.REQUIRE)
public class NorthboundBroker {
    @Reference
    private Core core;
    @Activate
    BundleContext bc;
    private static final Logger LOG = LoggerFactory.getLogger(NorthboundBroker.class);
    public static final String MQTT_AGENT_BROKER = "mqtt.agent.broker";
    private SnaEventEventHandler handler;

    @Activate
    public void activate(Map<String, Object> configMap) {
        Config config = (Config)Converters.standardConverter().convert(configMap).to(Config.class);
        Mediator mediator = new Mediator(this.bc);
        try {
            String types;
            String sender;
            String protocol;
            String prefix;
            String qos;
            String port;
            String host = config.host();
            if (host == null) {
                host = "127.0.0.1";
            }
            if ((port = config.port()) == null) {
                port = "1883";
            }
            if ((qos = config.qos()) == null) {
                qos = "1";
            }
            if ((prefix = config.prefix()) == null) {
                prefix = "/";
            }
            if ((protocol = config.protocol()) == null) {
                protocol = "tcp";
            }
            String username = config.username();
            String password = config._password();
            boolean defined = false;
            boolean isPattern = false;
            boolean isComplement = false;
            JSONArray constraints = null;
            SnaMessage.Type[] handled = null;
            String pattern = config.pattern();
            if (pattern != null) {
                isPattern = Boolean.parseBoolean(pattern);
                defined = true;
            }
            if ((sender = config.sender()) == null) {
                sender = "(/[^/]+)+";
                isPattern = true;
            } else {
                defined = true;
            }
            String complement = config.complement();
            if (complement != null) {
                isComplement = Boolean.parseBoolean(complement);
                defined = true;
            }
            if ((types = config.types()) == null) {
                handled = SnaMessage.Type.values();
            } else {
                try {
                    JSONArray array = new JSONArray(types);
                    handled = new SnaMessage.Type[array.length()];
                    for (int i = 0; i < array.length(); ++i) {
                        handled[i] = SnaMessage.Type.valueOf((String)array.getString(i));
                    }
                    defined = true;
                }
                catch (NullPointerException | JSONException e) {
                    handled = SnaMessage.Type.values();
                    LOG.error("Unable to build the array of handled message types", e);
                }
            }
            String conditions = config.conditions();
            if (conditions != null) {
                try {
                    constraints = new JSONArray(conditions);
                    defined = true;
                }
                catch (JSONException e) {
                    constraints = new JSONArray();
                    LOG.error("Unable to build the constraint expession", (Throwable)e);
                }
            }
            SnaFilter filter = null;
            if (defined) {
                filter = new SnaFilter(mediator, sender, isPattern, isComplement, constraints);
                filter.addHandledType(handled);
            }
            String broker = String.format("%s://%s:%s", protocol, host, port);
            this.handler = new SnaEventEventHandler(prefix);
            LOG.debug("Starting MQTT Agent point to server %s with prefix %s and qos %s", new Object[]{broker, prefix, qos});
            GenericMqttAgent agent = username != null && password != null && !username.toString().trim().equals("") && !password.toString().trim().equals("") ? new GenericMqttAgent(broker, Integer.parseInt(qos), prefix, username.toString(), password.toString()) : new GenericMqttAgent(broker, Integer.parseInt(qos), prefix);
            this.handler.setAgent(agent);
            this.core.registerAgent(mediator, (MidAgentCallback)this.handler, filter);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Deactivate
    public void deleted() {
        this.handler.stop();
    }

    @ObjectClassDefinition(factoryPid={"mqtt.agent.broker"})
    static interface Config {
        @AttributeDefinition(defaultValue={"127.0.0.1"})
        default public String host() {
            return "127.0.0.1";
        }

        @AttributeDefinition(defaultValue={"1883"})
        default public String port() {
            return "1883";
        }

        @AttributeDefinition(defaultValue={"1"})
        default public String qos() {
            return "1";
        }

        @AttributeDefinition(defaultValue={"/"})
        default public String prefix() {
            return "/";
        }

        @AttributeDefinition(defaultValue={"tcp"})
        default public String protocol() {
            return "tcp";
        }

        @AttributeDefinition
        default public String username() {
            return null;
        }

        @AttributeDefinition(type=AttributeType.PASSWORD)
        default public String _password() {
            return null;
        }

        default public String pattern() {
            return null;
        }

        default public String complement() {
            return null;
        }

        default public String sender() {
            return null;
        }

        default public String types() {
            return null;
        }

        default public String conditions() {
            return null;
        }
    }
}

