/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.test;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.sensinact.gateway.test.BundleContextProvider;

public class FilterOSGiClassLoader
extends ClassLoader {
    protected BundleContextProvider contextProvider;
    protected Map<String, Set<String>> filteredEntries;
    protected String loadingClass;
    protected String loadingResource;

    public FilterOSGiClassLoader(ClassLoader parent, BundleContextProvider contextProvider, URL[] filtered) throws IOException {
        super(parent);
        this.contextProvider = contextProvider;
        this.filteredEntries = new HashMap<String, Set<String>>();
        this.addFiltered(filtered);
    }

    public FilterOSGiClassLoader(ClassLoader parent, BundleContextProvider contextProvider, FilterOSGiClassLoader loader) throws IOException {
        super(parent);
        this.contextProvider = contextProvider;
        this.filteredEntries = new HashMap<String, Set<String>>();
        this.addFiltereds(loader);
    }

    @Override
    public Class<?> loadClass(String clazz) throws ClassNotFoundException {
        return this.loadClass(clazz, false);
    }

    @Override
    public Class<?> loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        String bundleName = this.isAFilteredClass(classname);
        if (bundleName != null) {
            return null;
        }
        clazz = classname.startsWith("[") ? Class.forName(classname) : super.loadClass(classname, resolve);
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        return resource;
    }

    @Override
    public URL findResource(String name) {
        String bundleName = this.isAFilteredResource(name);
        if (bundleName != null) {
            return null;
        }
        return super.findResource(name);
    }

    protected void addFiltered(URL[] urls) throws IOException {
        int length;
        int n = length = urls == null ? 0 : urls.length;
        for (int index = 0; index < length; ++index) {
            this.addFiltered(urls[index]);
        }
    }

    public void addFiltered(URL url) throws IOException {
        if (url == null) {
            return;
        }
        JarEntry jarEntry = null;
        JarInputStream jarInputStream = new JarInputStream(url.openStream());
        Manifest manifest = jarInputStream.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleName = attributes.getValue("Bundle-SymbolicName");
        HashSet<String> entrySet = new HashSet<String>();
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) continue;
            String excluded = jarEntry.getName();
            entrySet.add(excluded.replace('\\', '/'));
        }
        this.filteredEntries.put(bundleName, entrySet);
    }

    public void addFiltereds(FilterOSGiClassLoader filterClassLoader) throws IOException {
        this.filteredEntries.putAll(filterClassLoader.filteredEntries);
    }

    protected String isAFilteredClass(String clazzname) {
        String classname = clazzname.replace('.', '/');
        classname = classname + ".class";
        for (String bundleName : this.filteredEntries.keySet()) {
            if (!this.filteredEntries.get(bundleName).contains(classname)) continue;
            return bundleName;
        }
        return null;
    }

    protected String isAFilteredResource(String resource) {
        String searchResource = resource.replace('\\', '/');
        if (searchResource.startsWith("/")) {
            searchResource.substring(1);
        }
        for (String bundleName : this.filteredEntries.keySet()) {
            if (!this.filteredEntries.get(bundleName).contains(searchResource)) continue;
            return bundleName;
        }
        return null;
    }
}

