/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.test;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.sensinact.gateway.test.BundleContextProvider;
import org.eclipse.sensinact.gateway.test.FilterOSGiClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

public final class InnerOSGiClassLoader
extends FilterOSGiClassLoader {
    public InnerOSGiClassLoader(ClassLoader parent, BundleContextProvider contextProvider, FilterOSGiClassLoader loader) throws IOException {
        super(parent, contextProvider, loader);
    }

    private Bundle findBundle(String bundleName) {
        if (bundleName != null) {
            int length;
            Bundle[] bundles = this.contextProvider.getBundleContext().getBundles();
            int n = length = bundles == null ? 0 : bundles.length;
            for (int index = 0; index < length; ++index) {
                final Bundle tmp = bundles[index];
                if (!bundleName.equals(tmp.getSymbolicName())) continue;
                return AccessController.doPrivileged(new PrivilegedAction<Bundle>(){

                    @Override
                    public Bundle run() {
                        Bundle bundle = null;
                        bundle = (((BundleRevision)tmp.adapt(BundleRevision.class)).getTypes() & 1) != 0 && tmp.getState() == 4 ? InnerOSGiClassLoader.this.findBundle((String)tmp.getHeaders().get("Fragment-Host")) : tmp;
                        return bundle;
                    }
                });
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        String bundleName = this.isAFilteredClass(classname);
        if (bundleName != null) {
            if (this.loadingClass != null) {
                this.loadingClass = null;
                throw new ClassNotFoundException(classname);
            }
            this.loadingClass = classname;
            final Bundle bundle = this.findBundle(bundleName);
            if (bundle != null) {
                try {
                    ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                            if (wiring != null) {
                                return wiring.getClassLoader();
                            }
                            return null;
                        }
                    });
                    if (loader != null) {
                        Class<?> clazz2 = loader.loadClass(classname);
                        return clazz2;
                    }
                }
                finally {
                    this.loadingClass = null;
                }
            }
            return null;
        }
        clazz = classname.startsWith("[") ? Class.forName(classname) : super.loadClass(classname, resolve);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(final String name) {
        String bundleName = this.isAFilteredResource(name);
        if (bundleName != null) {
            if (this.loadingResource != null) {
                this.loadingResource = null;
                return null;
            }
            this.loadingResource = name;
            final Bundle bundle = this.findBundle(bundleName);
            if (bundle != null) {
                try {
                    URL url;
                    URL uRL = url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                        @Override
                        public URL run() {
                            return bundle.getResource(name);
                        }
                    });
                    return uRL;
                }
                finally {
                    this.loadingResource = null;
                }
            }
            return null;
        }
        return super.findResource(name);
    }
}

