/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.primitive;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Describable;
import org.eclipse.sensinact.gateway.common.primitive.Description;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Primitive;
import org.eclipse.sensinact.gateway.common.primitive.PrimitiveDescription;
import org.eclipse.sensinact.gateway.common.primitive.WeakDescription;
import org.json.JSONObject;

public abstract class DescribablePrimitive
extends Primitive
implements Describable {
    protected WeakDescription weakDescription;

    protected abstract <P extends PrimitiveDescription> P createDescription();

    protected DescribablePrimitive(Mediator mediator, String name, Class<?> type) throws InvalidValueException {
        super(mediator, name, type);
    }

    protected DescribablePrimitive(Mediator mediator, String name, String type) throws InvalidValueException {
        super(mediator, name, type);
    }

    protected DescribablePrimitive(Mediator mediator, String name, Class<?> type, Object value) throws InvalidValueException {
        super(mediator, name, type, value);
    }

    protected DescribablePrimitive(Mediator mediator, JSONObject jsonObject) throws InvalidValueException {
        super(mediator, jsonObject);
    }

    @Override
    protected void beforeChange(Object value) throws InvalidValueException {
    }

    @Override
    public void afterChange(Object value) throws InvalidValueException {
        if (this.weakDescription != null) {
            this.weakDescription.update(value);
        }
    }

    @Override
    public <D extends Description> D getDescription() {
        Description description = null;
        if (this.weakDescription == null || (description = (Description)this.weakDescription.get()) == null) {
            description = (Description)this.createDescription();
            this.weakDescription = new WeakDescription<PrimitiveDescription>((PrimitiveDescription)description);
        }
        return (D)description;
    }
}

