/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.interception.InterceptHandler;
import io.moquette.server.config.IConfig;
import io.moquette.server.config.IResourceLoader;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.SensiNactProtocolProcessor;
import io.moquette.spi.impl.security.ACLFileParser;
import io.moquette.spi.impl.security.AcceptAllAuthenticator;
import io.moquette.spi.impl.security.DenyAllAuthorizator;
import io.moquette.spi.impl.security.PermitAllAuthorizator;
import io.moquette.spi.impl.security.ResourceAuthenticator;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import io.moquette.spi.persistence.MapDBPersistentStore;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.sensinact.mqtt.server.internal.SensiNactServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensiNactProtocolProcessorBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SensiNactProtocolProcessorBootstrapper.class);
    private SubscriptionsStore subscriptions;
    private MapDBPersistentStore m_mapStorage;
    private ISessionsStore m_sessionsStore;
    private BrokerInterceptor m_interceptor;
    private final ProtocolProcessor m_processor;

    public SensiNactProtocolProcessorBootstrapper(BundleContext bundleContext) {
        this.m_processor = new SensiNactProtocolProcessor(bundleContext);
    }

    public ProtocolProcessor init(IConfig props, List<? extends InterceptHandler> embeddedObservers, IAuthenticator authenticator, IAuthorizator authorizator, SensiNactServer server) {
        String authorizatorClassName;
        this.subscriptions = new SubscriptionsStore();
        this.m_mapStorage = new MapDBPersistentStore(props);
        this.m_mapStorage.initStore();
        IMessagesStore messagesStore = this.m_mapStorage.messagesStore();
        this.m_sessionsStore = this.m_mapStorage.sessionsStore();
        ArrayList<InterceptHandler> observers = new ArrayList<InterceptHandler>(embeddedObservers);
        String interceptorClassName = props.getProperty("intercept.handler");
        if (interceptorClassName != null && !interceptorClassName.isEmpty()) {
            try {
                InterceptHandler handler;
                try {
                    Constructor<InterceptHandler> constructor = Class.forName(interceptorClassName).asSubclass(InterceptHandler.class).getConstructor(SensiNactServer.class);
                    handler = constructor.newInstance(server);
                }
                catch (NoSuchMethodException nsme) {
                    handler = Class.forName(interceptorClassName).asSubclass(InterceptHandler.class).newInstance();
                }
                observers.add(handler);
            }
            catch (Throwable ex) {
                LOG.error("Can't load the intercept handler {}", ex);
            }
        }
        this.m_interceptor = new BrokerInterceptor(observers);
        this.subscriptions.init(this.m_sessionsStore);
        String configPath = System.getProperty("moquette.path", null);
        String authenticatorClassName = props.getProperty("authenticator_class", "");
        if (!authenticatorClassName.isEmpty()) {
            authenticator = (IAuthenticator)this.loadClass(authenticatorClassName, IAuthenticator.class, props);
            LOG.info("Loaded custom authenticator {}", (Object)authenticatorClassName);
        }
        IResourceLoader resourceLoader = props.getResourceLoader();
        if (authenticator == null) {
            String passwdPath = props.getProperty("password_file", "");
            authenticator = passwdPath.isEmpty() ? new AcceptAllAuthenticator() : new ResourceAuthenticator(resourceLoader, passwdPath);
        }
        if (!(authorizatorClassName = props.getProperty("authorizator_class", "")).isEmpty()) {
            authorizator = (IAuthorizator)this.loadClass(authorizatorClassName, IAuthorizator.class, props);
            LOG.info("Loaded custom authorizator {}", (Object)authorizatorClassName);
        }
        if (authorizator == null) {
            String aclFilePath = props.getProperty("acl_file", "");
            if (aclFilePath != null && !aclFilePath.isEmpty()) {
                authorizator = new DenyAllAuthorizator();
                try {
                    authorizator = ACLFileParser.parse(resourceLoader.loadResource(aclFilePath));
                }
                catch (ParseException pex) {
                    LOG.error(String.format("Format error in parsing acl %s %s", resourceLoader.getName(), aclFilePath), (Throwable)pex);
                }
                LOG.info("Using acl file defined at path {}", (Object)aclFilePath);
            } else {
                authorizator = new PermitAllAuthorizator();
                LOG.info("Starting without ACL definition");
            }
        }
        boolean allowAnonymous = Boolean.parseBoolean(props.getProperty("allow_anonymous", "true"));
        boolean allowZeroByteClientId = Boolean.parseBoolean(props.getProperty("allow_zero_byte_client_id", "false"));
        this.m_processor.init(this.subscriptions, messagesStore, this.m_sessionsStore, authenticator, allowAnonymous, allowZeroByteClientId, authorizator, this.m_interceptor, props.getProperty("port"));
        return this.m_processor;
    }

    private Object loadClass(String className, Class<?> cls, IConfig props) {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            try {
                instance = method.invoke(null, new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                LOG.error(null, (Throwable)ex);
                throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
            }
            catch (InvocationTargetException ex) {
                LOG.error(null, (Throwable)ex);
                throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error(null, (Throwable)ex);
                throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
            }
        }
        catch (NoSuchMethodException nsmex) {
            try {
                instance = this.getClass().getClassLoader().loadClass(className).asSubclass(cls).getConstructor(IConfig.class).newInstance(props);
            }
            catch (Exception e) {
                try {
                    instance = this.getClass().getClassLoader().loadClass(className).asSubclass(cls).newInstance();
                }
                catch (Exception ex) {
                    LOG.error(null, (Throwable)ex);
                    throw new RuntimeException("Cannot load custom authenticator class " + className, ex);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
            throw new RuntimeException("Class " + className + " not found", ex);
        }
        catch (SecurityException ex) {
            LOG.error(null, (Throwable)ex);
            throw new RuntimeException("Cannot call method " + className + ".getInstance", ex);
        }
        return instance;
    }

    public List<Subscription> getSubscriptions() {
        return this.m_sessionsStore.getSubscriptions();
    }

    public void shutdown() {
        this.m_mapStorage.close();
    }
}

