/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb.read;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricRequest;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.TemporalDTO;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDBTagDTO;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnector;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxDBRequest<T>
implements HistoricRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBRequest.class);
    private static final List<String> REPLACEMENTS = Arrays.asList(":", ".", "-", "[", "]", "(", ")", "{", "}", "+");
    protected String database;
    protected String measurement;
    protected List<ResourceInfo> resources = new ArrayList<ResourceInfo>();
    protected InfluxDbConnector influxDbConnector;

    public InfluxDBRequest(InfluxDbConnector influxDbConnector) {
        this.influxDbConnector = influxDbConnector;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void addTargetResource(String provider, String service, String resource) {
        this.resources.add(new ResourceInfo(provider, service, resource));
    }

    protected InfluxDBTagDTO getDataSourcePath(ResourceInfo ri) {
        InfluxDBTagDTO historicAttributeDTO = new InfluxDBTagDTO();
        historicAttributeDTO.name = "path";
        String datasource = null;
        if (ri.resource == null) {
            if (ri.provider == null) {
                return null;
            }
            datasource = ri.provider;
            for (String replacement : REPLACEMENTS) {
                datasource = datasource.replace(replacement, "\\".concat(replacement));
            }
            historicAttributeDTO.value = "/(" + datasource + "\\/([^\\/]+\\/?)+)/";
            historicAttributeDTO.pattern = true;
            return historicAttributeDTO;
        }
        if (ri.provider == null) {
            if (ri.service == null) {
                return null;
            }
            datasource = ri.service;
            for (String replacement : REPLACEMENTS) {
                datasource = datasource.replace(replacement, "\\".concat(replacement));
            }
            historicAttributeDTO.value = datasource = "/([^\\/]+\\/" + datasource + "\\/[^\\/]+)/";
            historicAttributeDTO.pattern = true;
            return historicAttributeDTO;
        }
        historicAttributeDTO.value = "/" + ri.provider + "/" + ri.service + "/" + ri.resource + "/" + "value";
        historicAttributeDTO.pattern = false;
        return historicAttributeDTO;
    }

    protected InfluxDBTagDTO getResource(ResourceInfo ri) {
        if (ri.resource == null) {
            return null;
        }
        InfluxDBTagDTO historicAttributeDTO = new InfluxDBTagDTO();
        historicAttributeDTO.name = "resource";
        historicAttributeDTO.value = ri.resource;
        historicAttributeDTO.pattern = false;
        return historicAttributeDTO;
    }

    private List<TemporalDTO> buildTemporalDTOList(QueryResult result) {
        List serie = null;
        try {
            serie = ((QueryResult.Series)((QueryResult.Result)result.getResults().get(0)).getSeries().get(0)).getValues();
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
        ArrayList<TemporalDTO> list = new ArrayList<TemporalDTO>();
        for (int i = 0; i < serie.size(); ++i) {
            TemporalDTO dto = null;
            try {
                dto = new TemporalDTO();
                dto.tagID = i;
                dto.timestamp = Instant.parse(String.valueOf(((List)serie.get(i)).get(0))).toEpochMilli();
                dto.value = String.valueOf(((List)serie.get(i)).get(1));
                list.add(dto);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (dto == null) continue;
                dto.error = e.getMessage();
                list.add(dto);
            }
        }
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"));
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, ZonedDateTime start) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"), start);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow, ZonedDateTime start) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow, start);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, ZonedDateTime start, ZonedDateTime end) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"), start, end);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow, ZonedDateTime start, ZonedDateTime end) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow, start, end);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    public static class ResourceInfo {
        public final String provider;
        public final String service;
        public final String resource;

        public ResourceInfo(String provider, String service, String resource) {
            this.provider = provider;
            this.service = service;
            this.resource = resource;
        }

        public String getPath() {
            return String.format("%s/%s/%s", this.provider, this.service, this.resource);
        }
    }
}

