/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb.read;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.gateway.agent.storage.influxdb.read.AbstractInfluxDBValueRequest;
import org.eclipse.sensinact.gateway.agent.storage.influxdb.read.InfluxDBRequest;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricValueRequest;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.TemporalDTO;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnector;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.influxdb.dto.QueryResult;

public class InfluxDBValueRequest
extends AbstractInfluxDBValueRequest<TemporalDTO>
implements HistoricValueRequest {
    public InfluxDBValueRequest(InfluxDbConnector influxDbConnector) {
        super(influxDbConnector);
    }

    public Map<String, TemporalDTO> execute() {
        InfluxDbDatabase db = this.influxDbConnector.getIfExists(this.database);
        if (db == null || this.resources.isEmpty()) {
            return Collections.emptyMap();
        }
        List measures = Stream.of("_num", "_str").map(this.measurement::concat).collect(Collectors.toList());
        List tags = this.resources.stream().map(this::getDataSourcePath).map(Collections::singletonList).collect(Collectors.toList());
        QueryResult results = db.getPointInTimeResults(measures, tags, this.time);
        HashMap<String, TemporalDTO> map = new HashMap<String, TemporalDTO>();
        for (int i = 0; i < this.resources.size(); ++i) {
            String key = ((InfluxDBRequest.ResourceInfo)this.resources.get(i)).getPath();
            QueryResult.Result r = (QueryResult.Result)results.getResults().get(i);
            if (r.getSeries() == null) {
                map.put(key, null);
                continue;
            }
            TemporalDTO dto = new TemporalDTO();
            dto.tagID = 0;
            QueryResult.Series series = (QueryResult.Series)r.getSeries().get(0);
            block9: for (int j = 0; j < series.getColumns().size(); ++j) {
                String column = (String)series.getColumns().get(j);
                Object value = ((List)series.getValues().get(0)).get(j);
                switch (column) {
                    case "time": {
                        dto.timestamp = value == null ? 0L : OffsetDateTime.parse(value.toString()).toInstant().toEpochMilli();
                        continue block9;
                    }
                    case "value": {
                        dto.value = value == null ? null : value.toString();
                        continue block9;
                    }
                }
            }
            map.put(key, dto);
        }
        return map;
    }
}

