/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.subscribe;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.discovery.zookeeper.repository.ZookeeperEndpointRepository;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterestManager
implements EndpointEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(InterestManager.class);
    private final ZookeeperEndpointRepository repository;
    private final Map<ServiceReference, Interest> interests = new ConcurrentHashMap<ServiceReference, Interest>();

    public InterestManager(ZookeeperEndpointRepository repository) {
        this.repository = repository;
    }

    public void addInterest(ServiceReference<?> sref, Object epListener) {
        if (InterestManager.isOurOwnEndpointEventListener(sref)) {
            LOG.debug("Skipping our own EndpointEventListener");
            return;
        }
        List<String> scopes = this.getScopes(sref);
        LOG.debug("adding Interests: {}", scopes);
        Interest interest = this.interests.get(epListener);
        if (interest == null) {
            interest = new Interest();
            interest.epListener = epListener;
            interest.scopes = scopes;
            this.interests.put(sref, interest);
            this.sendExistingEndpoints(scopes, epListener);
        }
    }

    private void sendExistingEndpoints(List<String> scopes, Object epListener) {
        for (EndpointDescription endpoint : this.repository.getAll()) {
            EndpointEvent event = new EndpointEvent(1, endpoint);
            this.notifyListener(event, scopes, epListener);
        }
    }

    private static boolean isOurOwnEndpointEventListener(ServiceReference<?> EndpointEventListener2) {
        return Boolean.parseBoolean(String.valueOf(EndpointEventListener2.getProperty("org.apache.cxf.dosgi.discovery.zookeeper")));
    }

    public void removeInterest(ServiceReference<EndpointEventListener> epListenerRef) {
        LOG.info("removing EndpointEventListener interests: {}", epListenerRef);
        this.interests.remove(epListenerRef);
    }

    public void endpointChanged(EndpointEvent event, String filter) {
        for (Interest interest : this.interests.values()) {
            this.notifyListener(event, interest.scopes, interest.epListener);
        }
    }

    private void notifyListener(EndpointEvent event, List<String> scopes, Object service) {
        EndpointDescription endpoint = event.getEndpoint();
        String currentScope = this.getFirstMatch(scopes, endpoint);
        if (currentScope == null) {
            return;
        }
        LOG.debug("Matched {} against {}", (Object)endpoint, (Object)currentScope);
        if (service instanceof EndpointEventListener) {
            this.notifyEEListener(event, currentScope, (EndpointEventListener)service);
        } else if (service instanceof EndpointListener) {
            this.notifyEListener(event, currentScope, (EndpointListener)service);
        }
    }

    private String getFirstMatch(List<String> scopes, EndpointDescription endpoint) {
        for (String scope : scopes) {
            if (!endpoint.matches(scope)) continue;
            return scope;
        }
        return null;
    }

    private void notifyEEListener(EndpointEvent event, String currentScope, EndpointEventListener listener) {
        EndpointDescription endpoint = event.getEndpoint();
        LOG.info("Calling endpointchanged on class {} for filter {}, type {}, endpoint {} ", new Object[]{listener, currentScope, endpoint});
        listener.endpointChanged(event, currentScope);
    }

    private void notifyEListener(EndpointEvent event, String currentScope, EndpointListener listener) {
        EndpointDescription endpoint = event.getEndpoint();
        LOG.info("Calling old listener on class {} for filter {}, type {}, endpoint {} ", new Object[]{listener, currentScope, endpoint});
        switch (event.getType()) {
            case 1: {
                listener.endpointAdded(endpoint, currentScope);
                break;
            }
            case 4: {
                listener.endpointAdded(endpoint, currentScope);
                listener.endpointRemoved(endpoint, currentScope);
                break;
            }
            case 2: {
                listener.endpointRemoved(endpoint, currentScope);
            }
        }
    }

    public synchronized void close() {
        this.interests.clear();
    }

    protected synchronized Map<ServiceReference, Interest> getInterests() {
        return this.interests;
    }

    protected List<String> getScopes(ServiceReference<?> sref) {
        return StringPlus.normalize((Object)sref.getProperty("endpoint.listener.scope"));
    }

    protected static class Interest {
        List<String> scopes;
        Object epListener;

        protected Interest() {
        }
    }
}

