/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Elements;
import org.eclipse.sensinact.gateway.common.primitive.ElementsProxy;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.ProcessableData;
import org.eclipse.sensinact.gateway.core.ElementsProxyWrapper;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelElement;
import org.eclipse.sensinact.gateway.core.SessionKey;
import org.eclipse.sensinact.gateway.core.UnaccessibleModelElementProxy;
import org.eclipse.sensinact.gateway.core.UnaccessibleModelElementProxyWrapper;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaNotificationMessageImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelElement<I extends ModelInstance<?>, M extends ModelElementProxy, P extends ProcessableData, E extends Nameable, R extends Nameable>
extends Elements<E>
implements SensiNactResourceModelElement<M> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelElement.class);
    protected final ModelElement<I, ?, ?, ?, ?> parent;
    protected I modelInstance;
    protected Map<String, AccessLevelOption> sessions;
    protected EnumMap<AccessLevelOption, M> proxies;
    protected AtomicBoolean started;

    protected abstract SnaLifecycleMessage.Lifecycle getRegisteredEvent();

    protected abstract SnaLifecycleMessage.Lifecycle getUnregisteredEvent();

    protected abstract Class<? extends ElementsProxy<R>> getProxyType();

    public abstract void process(P var1);

    protected abstract R getElementProxy(AccessTree<?> var1, E var2) throws ModelElementProxyBuildException;

    protected abstract ModelElementProxyWrapper getWrapper(M var1, ImmutableAccessTree var2);

    protected ModelElement(I modelInstance, ModelElement<I, ?, ?, ?, ?> parent, String uri) {
        super(uri);
        if (parent != null && parent.getModelInstance() != modelInstance) {
            throw new RuntimeException("Inconsistent hierarchy");
        }
        this.parent = parent;
        this.modelInstance = modelInstance;
        this.started = new AtomicBoolean(false);
        this.sessions = new HashMap<String, AccessLevelOption>();
        this.proxies = new EnumMap(AccessLevelOption.class);
    }

    public I getModelInstance() {
        return this.modelInstance;
    }

    public <S extends ElementsProxy<R>> S getProxy(SessionKey key) throws ModelElementProxyBuildException {
        if (!this.started.get()) {
            throw new ModelElementProxyBuildException("this model element must be started first");
        }
        AccessTree<? extends AccessNode> accessTree = key.getAccessTree();
        if (accessTree == null || accessTree.getRoot() == null) {
            throw new ModelElementProxyBuildException("A valid access tree was expected");
        }
        return this.getProxy(accessTree);
    }

    public final <S extends ElementsProxy<R>> S getProxy(AccessTree<?> tree) throws ModelElementProxyBuildException {
        if (!this.started.get()) {
            throw new ModelElementProxyBuildException(String.format("this model element '%s' must be started first", this.getName()));
        }
        AccessNode node = tree.getRoot().get(super.getPath());
        AccessLevelOption accessLevelOption = node.getAccessLevelOption(AccessMethod.Type.valueOf(AccessMethod.DESCRIBE));
        if (accessLevelOption == null) {
            throw new ModelElementProxyBuildException("Access level option expected");
        }
        Class<ElementsProxy<R>> proxied = this.getProxyType();
        ModelElementProxy proxy = (ModelElementProxy)this.proxies.get((Object)accessLevelOption);
        if (proxy == null) {
            List<MethodAccessibility> methodAccessibilities = ((ModelInstance)this.modelInstance).getAuthorizations(this, accessLevelOption);
            if (methodAccessibilities.stream().filter(ma -> AccessMethod.DESCRIBE.equals(ma.getName())).map(ma -> !ma.isAccessible()).findFirst().orElse(true).booleanValue()) {
                return (S)((ElementsProxy)Proxy.newProxyInstance(ModelElement.class.getClassLoader(), new Class[]{proxied}, (InvocationHandler)new UnaccessibleModelElementProxyWrapper(new UnaccessibleModelElementProxy(((ModelInstance)this.modelInstance).mediator(), proxied, this.getPath()))));
            }
            proxy = this.getProxy(methodAccessibilities);
        }
        if (proxy == null) {
            return null;
        }
        this.proxies.put(accessLevelOption, proxy);
        ImmutableAccessTree accessTree = null;
        accessTree = tree.isMutable() ? ((MutableAccessTree)tree).immutable() : (ImmutableAccessTree)tree;
        ModelElementProxyWrapper wrapper = this.getWrapper(proxy, accessTree);
        return (S)((ElementsProxy)Proxy.newProxyInstance(ModelElement.class.getClassLoader(), new Class[]{proxied}, (InvocationHandler)wrapper));
    }

    protected <TASK> TASK passOn(String type, String uri, Object[] parameters) throws Exception {
        if (this.parent != null) {
            return this.parent.passOn(type, uri, parameters);
        }
        return null;
    }

    public boolean addElement(E element) {
        if (!super.addElement(element)) {
            return false;
        }
        if (this.started.get() && ModelElement.class.isAssignableFrom(element.getClass())) {
            ((ModelElement)element).start();
        }
        return true;
    }

    public E removeElement(String name) {
        Nameable element = null;
        element = super.removeElement(name);
        if (element != null) {
            if (this.started.get() && ModelElement.class.isAssignableFrom(element.getClass())) {
                ((ModelElement)element).stop();
            }
            return (E)element;
        }
        return null;
    }

    protected void start() {
        try {
            if (!((ModelInstance)this.modelInstance).isRegistered()) {
                LOG.error("%s not registered", (Object)((ModelInstance)this.modelInstance).getName());
                return;
            }
            if (this.started.get()) {
                LOG.debug("%s already started", (Object)this.getName());
                return;
            }
            this.started.set(true);
            String path = super.getPath();
            SnaLifecycleMessage.Lifecycle event = this.getRegisteredEvent();
            SnaLifecycleMessage notification = (SnaLifecycleMessage)SnaNotificationMessageImpl.Builder.notification(((ModelInstance)this.modelInstance).mediator(), event, path);
            JSONObject notificationObject = new JSONObject();
            notificationObject.put("lifecycle", (Object)event.name());
            notification.setNotification(notificationObject);
            ((ModelInstance)this.modelInstance).postMessage(notification);
            this.forEach(new Executable<E, Void>(){

                public Void execute(E element) throws Exception {
                    if (ModelElement.class.isAssignableFrom(element.getClass())) {
                        ((ModelElement)element).start();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void stop() {
        if (!this.started.get()) {
            LOG.debug("%s not started", (Object)this.getName());
            return;
        }
        this.started.set(false);
        this.proxies.clear();
        try {
            this.forEach(new Executable<E, Void>(){

                public Void execute(E element) throws Exception {
                    if (ModelElement.class.isAssignableFrom(element.getClass())) {
                        ((ModelElement)element).stop();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        SnaLifecycleMessage.Lifecycle event = this.getUnregisteredEvent();
        String path = super.getPath();
        SnaLifecycleMessage notification = (SnaLifecycleMessage)SnaNotificationMessageImpl.Builder.notification(((ModelInstance)this.modelInstance).mediator(), event, path);
        JSONObject notificationObject = new JSONObject();
        notificationObject.put("lifecycle", (Object)event.name());
        notification.setNotification(notificationObject);
        ((ModelInstance)this.modelInstance).postMessage(notification);
    }

    static abstract class ModelElementProxyWrapper
    extends ElementsProxyWrapper<M, R> {
        private final ImmutableAccessTree tree;
        final /* synthetic */ ModelElement this$0;

        protected ModelElementProxyWrapper(M proxy, ImmutableAccessTree tree) {
            this.this$0 = this$0;
            super(proxy);
            this.tree = tree;
        }

        public R element(String name) {
            Nameable e = this.this$0.element(name);
            if (e == null) {
                return null;
            }
            try {
                Object r = this.this$0.getElementProxy(this.tree, e);
                return r;
            }
            catch (ModelElementProxyBuildException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration<R> elements() {
            Object[] es;
            List list = this.this$0.elements;
            synchronized (list) {
                es = this.this$0.elements.toArray(new Object[0]);
            }
            return new Enumeration<R>(){
                int pos = 0;
                R r = this.next();

                private R next() {
                    while (this.pos < es.length) {
                        try {
                            Object r = ModelElementProxyWrapper.this.this$0.getElementProxy(ModelElementProxyWrapper.this.tree, (Nameable)es[this.pos++]);
                            if (r == null || Proxy.isProxyClass(r.getClass()) && !((ElementsProxyWrapper)Proxy.getInvocationHandler(r)).isAccessible()) continue;
                            return r;
                        }
                        catch (ModelElementProxyBuildException e1) {
                            e1.printStackTrace();
                        }
                    }
                    return null;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.r != null;
                }

                @Override
                public R nextElement() {
                    Object current = this.r;
                    this.r = this.next();
                    return current;
                }
            };
        }

        protected List<R> list() {
            ArrayList list = new ArrayList();
            Enumeration elements = this.elements();
            while (elements.hasMoreElements()) {
                list.add(elements.nextElement());
            }
            return Collections.unmodifiableList(list);
        }
    }
}

