/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.common.primitive.Describable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.PathElement;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.Signature;

public interface AccessMethod<T, R extends AccessMethodResponse<T>>
extends Nameable,
Describable,
PathElement {
    public static final String REQUEST_ID_KEY = "rid";
    public static final String GET = "GET".intern();
    public static final String SET = "SET".intern();
    public static final String ACT = "ACT".intern();
    public static final String SUBSCRIBE = "SUBSCRIBE".intern();
    public static final String UNSUBSCRIBE = "UNSUBSCRIBE".intern();
    public static final String DESCRIBE = "DESCRIBE".intern();
    public static final Object EMPTY = new Object();

    public Set<Signature> getSignatures();

    public int size();

    public ErrorHandler getErrorHandler();

    public Type getType();

    public R invoke(Object[] var1);

    public static class Type {
        private static final Map<String, Type> METHODS = new HashMap<String, Type>();
        private static boolean initialized = false;
        private final String name;
        private final AccessMethodResponse.Response response;
        private final int ordinal;

        private static final void initialize() {
            if (initialized) {
                return;
            }
            initialized = true;
            new Type(GET, AccessMethodResponse.Response.GET_RESPONSE);
            new Type(SET, AccessMethodResponse.Response.SET_RESPONSE);
            new Type(ACT, AccessMethodResponse.Response.ACT_RESPONSE);
            new Type(SUBSCRIBE, AccessMethodResponse.Response.SUBSCRIBE_RESPONSE);
            new Type(UNSUBSCRIBE, AccessMethodResponse.Response.UNSUBSCRIBE_RESPONSE);
            new Type(DESCRIBE, AccessMethodResponse.Response.DESCRIBE_RESPONSE);
        }

        public static final Type valueOf(String name) {
            if (!initialized) {
                Type.initialize();
            }
            if (name == null) {
                return null;
            }
            return METHODS.get(name);
        }

        public static final Type valueOf(AccessMethodResponse.Response response) {
            if (!initialized) {
                Type.initialize();
            }
            if (response == null) {
                return null;
            }
            Collection<Type> methods = METHODS.values();
            Iterator<Type> it = methods.iterator();
            Type m = null;
            while (it.hasNext()) {
                m = it.next();
                if (!response.equals(m.response)) continue;
                return m;
            }
            return null;
        }

        public static final Type[] values() {
            if (!initialized) {
                Type.initialize();
            }
            Collection<Type> collection = METHODS.values();
            Type[] types = new Type[collection.size()];
            Iterator<Type> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Type t;
                types[t.ordinal()] = t = iterator.next();
            }
            return types;
        }

        public Type(String name, AccessMethodResponse.Response response) {
            if (Type.valueOf(name) != null) {
                throw new IllegalArgumentException("This method already exists");
            }
            this.name = name;
            this.response = response;
            this.ordinal = METHODS.size();
            METHODS.put(this.name, this);
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return this.ordinal;
        }

        public AccessMethodResponse.Response getReturnedType() {
            return this.response;
        }

        public int hashCode() {
            return this.ordinal();
        }

        public boolean equals(Object o) {
            if (Type.class.isAssignableFrom(o.getClass())) {
                return ((Type)o).ordinal() == this.ordinal();
            }
            return false;
        }

        static {
            Type.initialize();
        }
    }
}

