/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.MethodAccess;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;

public class MethodAccessibilityImpl
implements MethodAccessibility {
    private final AccessMethod.Type method;
    private final AccessLevelOption option;
    private final boolean accessible;

    public static MethodAccessibility unaccessible(AccessMethod.Type method, AccessLevelOption option) {
        return new MethodAccessibilityImpl(method, option, false);
    }

    public static List<MethodAccessibility> unaccessible(AccessLevelOption option) {
        int length;
        ArrayList<MethodAccessibility> accessibilities = new ArrayList<MethodAccessibility>();
        AccessMethod.Type[] types = AccessMethod.Type.values();
        int n = length = types == null ? 0 : types.length;
        for (int index = 0; index < length; ++index) {
            accessibilities.add(new MethodAccessibilityImpl(types[index], option, false));
        }
        return accessibilities;
    }

    public MethodAccessibilityImpl(MethodAccess methodAccess, AccessLevelOption option) {
        this(methodAccess.getMethod(), option, methodAccess.getAccessLevel().getLevel() <= option.getAccessLevel().getLevel());
    }

    public MethodAccessibilityImpl(AccessMethod.Type method, AccessLevelOption option, boolean accessible) {
        if (option == null) {
            throw new NullPointerException("NULL OPTION");
        }
        this.method = method;
        this.option = option;
        this.accessible = accessible;
    }

    public String getName() {
        return this.method.name();
    }

    @Override
    public AccessMethod.Type getMethod() {
        return this.method;
    }

    @Override
    public AccessLevelOption getAccessLevelOption() {
        return this.option;
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (AccessLevelOption.class == object.getClass()) {
            return object.equals((Object)this.option);
        }
        if (String.class == object.getClass()) {
            return object.equals(this.getName());
        }
        if (AccessMethod.Type.class == object.getClass()) {
            return object.equals(this.method);
        }
        if (MethodAccessibility.class.isAssignableFrom(object.getClass())) {
            return this.equals(((MethodAccessibility)object).getMethod()) && this.equals((Object)((MethodAccessibility)object).getAccessLevelOption());
        }
        return false;
    }

    public String toString() {
        String m = this.method == null ? "NO_METHOD" : this.method.name();
        String o = this.option == null ? "NO_OPTION" : this.option.name();
        return m + "[Level:" + o + "]" + "[Accessible:" + this.accessible + "]";
    }
}

