/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

final class LogException
extends Exception {
    private static final long serialVersionUID = 1296580652284691039L;
    private final String m_className;
    private final String m_message;
    private final String m_localizedMessage;
    private static final String JAVA_PACKAGE_PREFIX = "java.";

    private LogException(Throwable exception) {
        this.m_className = exception.getClass().getName();
        this.m_message = exception.getMessage();
        this.m_localizedMessage = exception.getLocalizedMessage();
        this.setStackTrace(exception.getStackTrace());
        Throwable cause = exception.getCause();
        if (cause != null) {
            cause = LogException.getException(cause);
            this.initCause(cause);
        }
    }

    @Override
    public String getMessage() {
        return this.m_className + ": " + this.m_message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.m_className + ": " + this.m_localizedMessage;
    }

    static Throwable getException(Throwable exception) {
        Throwable result = null;
        if (exception != null) {
            String className = exception.getClass().getName();
            result = exception.getCause() == null && className.startsWith(JAVA_PACKAGE_PREFIX) ? exception : new LogException(exception);
        }
        return result;
    }
}

