/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.discovery;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import org.eclipse.sensinact.gateway.protocol.ssdp.discovery.SSDPAbstractListenerThread;
import org.eclipse.sensinact.gateway.protocol.ssdp.listener.SSDPDiscoveryNotifier;
import org.eclipse.sensinact.gateway.protocol.ssdp.parser.SSDPDiscoveryParser;

public class SSDPMulticastListenerThread
extends SSDPAbstractListenerThread {
    public SSDPMulticastListenerThread(SSDPDiscoveryNotifier notifier, NetworkInterface networkInterface) {
        super(notifier, networkInterface);
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (DatagramSocket multicastSocket = null;){
            InetAddress group = InetAddress.getByName("239.255.255.250");
            multicastSocket = new MulticastSocket(1900);
            ((MulticastSocket)multicastSocket).joinGroup(group);
            ((MulticastSocket)multicastSocket).setNetworkInterface(this.networkInterface);
            while (this.running) {
                if (!multicastSocket.isBound()) continue;
                byte[] buf = new byte[1000];
                DatagramPacket recv = new DatagramPacket(buf, buf.length);
                multicastSocket.receive(recv);
                this.notifier.newSSDPPacket(SSDPDiscoveryParser.parse(new String(buf)));
            }
            ((MulticastSocket)multicastSocket).leaveGroup(group);
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }
}

