/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnMetadata;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnPacketPayload;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnSubPacket;
import org.json.JSONException;
import org.json.JSONObject;

public class TtnActivationPayload
extends TtnPacketPayload {
    private final String applicationEui;
    private final String deviceEui;
    private final String deviceAddress;
    private final TtnMetadata metadata;

    public TtnActivationPayload(String applicationEui, String deviceEui, String deviceAddress, TtnMetadata metadata) {
        this.applicationEui = applicationEui;
        this.deviceEui = deviceEui;
        this.deviceAddress = deviceAddress;
        this.metadata = metadata;
    }

    public TtnActivationPayload(JSONObject json) throws JSONException {
        this.applicationEui = json.getString("app_eui");
        this.deviceEui = json.getString("dev_eui");
        this.deviceAddress = json.getString("dev_addr");
        this.metadata = new TtnMetadata(json.getJSONObject("metadata"));
    }

    public String getApplicationEui() {
        return this.applicationEui;
    }

    public String getDeviceEui() {
        return this.deviceEui;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public TtnMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public List<TtnSubPacket<?>> getSubPackets() {
        ArrayList subPackets = new ArrayList();
        subPackets.add(new TtnSubPacket<Double>("system", "frequency", null, null, this.metadata.getFrequency()));
        subPackets.add(new TtnSubPacket<String>("system", "modulation", null, null, this.metadata.getModulation()));
        subPackets.add(new TtnSubPacket<String>("system", "data_rate", null, null, this.metadata.getDataRate()));
        subPackets.add(new TtnSubPacket<String>("system", "coding_rate", null, null, this.metadata.getCodingRate()));
        return subPackets;
    }
}

