/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.http.test.HttpServiceTestClient;
import org.eclipse.sensinact.gateway.nthbnd.rest.ws.test.WsServiceTestClient;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.junit5.context.BundleContextExtension;

@ExtendWith(value={BundleContextExtension.class})
public class TestRestACTAccess {
    @BeforeEach
    public void before(@InjectBundleContext BundleContext context) {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/turn_off/ACT", null, "POST");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/dim/ACT", "{\"parameters\":[{\"name\": \"brightness\",\"value\": 10,\"type\": \"int\"}]}", "POST");
        response = new JSONObject(simulated);
        Assertions.assertEquals((Object)200, (Object)response.get("statusCode"));
    }

    @Test
    public void testHttpACTWithoutParameters(@InjectBundleContext BundleContext context) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/status/GET", null, "GET");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("OFF"));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/turn_on/ACT", null, "POST");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/status/GET", null, "GET");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("ON"));
    }

    @Test
    public void testSimplifiedHttpACTWithoutParameters(@InjectBundleContext BundleContext context) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/light/switch/status/GET", null, "GET");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertEquals((Object)response.getJSONObject("response").get("value"), (Object)"OFF");
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/light/switch/turn_on/ACT", null, "POST");
        System.out.println(simulated);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/light/switch/status/GET", null, "GET");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("ON"));
    }

    @Test
    public void testHttpACTWithParameters(@InjectBundleContext BundleContext context) throws Exception {
        Mediator mediator = new Mediator(context);
        String simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers", null, "GET");
        System.out.println(simulated);
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/brightness/GET", null, "GET");
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/brightness"));
        Assertions.assertEquals((Object)10, (Object)response.getJSONObject("response").get("value"));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/dim/ACT", "{\"parameters\":[{\"name\": \"brightness\",\"value\": 5,\"type\": \"int\"}]}", "POST");
        System.out.println(simulated);
        response = new JSONObject(simulated);
        System.out.println(response.toString());
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/dim"));
        simulated = HttpServiceTestClient.newRequest(mediator, "http://127.0.0.1:8899/sensinact/providers/light/services/switch/resources/brightness/GET", null, "GET");
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/brightness"));
        System.out.println(response.toString());
        Assertions.assertEquals((int)5, (int)response.getJSONObject("response").getInt("value"));
    }

    @Test
    public void testWsACTWithoutParameters(@InjectBundleContext BundleContext context) throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/status/GET", null);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("OFF"));
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/turn_on/ACT", null);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/status/GET", null);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/status"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals("ON"));
    }

    @Test
    public void testWsACTWithParameters() throws Exception {
        WsServiceTestClient client = new WsServiceTestClient();
        new Thread(client).start();
        String simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/brightness/GET", null);
        JSONObject response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/brightness"));
        Assertions.assertTrue((boolean)response.getJSONObject("response").get("value").equals(10));
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/dim/ACT", "[{\"name\": \"brightness\",\"value\": 5,\"type\": \"int\"}]");
        System.out.println(simulated);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/dim"));
        simulated = null;
        simulated = this.synchronizedRequest(client, "/sensinact/providers/light/services/switch/resources/brightness/GET", null);
        response = new JSONObject(simulated);
        Assertions.assertTrue((boolean)response.get("statusCode").equals(200));
        Assertions.assertTrue((boolean)response.getString("uri").equals("/light/switch/brightness"));
        System.out.println(response.toString());
        Assertions.assertEquals((int)5, (int)response.getJSONObject("response").getInt("value"));
    }

    private String synchronizedRequest(WsServiceTestClient client, String url, String content) {
        String simulated = null;
        long wait = 10000L;
        client.newRequest(url, content);
        while (!client.isAvailable() && wait > 0L) {
            wait -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            simulated = client.getResponseMessage();
        }
        return simulated;
    }
}

