/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats;

import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.exception.ProcessorFormatException;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.iface.ProcessorFormatIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.selector.SelectorIface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorFormatMultiply
implements ProcessorFormatIface {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorFormatMultiply.class);

    @Override
    public String getName() {
        return "multiply";
    }

    @Override
    public String process(String inData, SelectorIface selector) throws ProcessorFormatException {
        try {
            String expression = selector.getExpression();
            try {
                Float inDataValue = new Float(inData);
                Float value = new Float(expression);
                return Float.valueOf(inDataValue.floatValue() * value.floatValue()).toString();
            }
            catch (NumberFormatException e) {
                return inData.concat(selector.getExpression());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to apply {} filter. Bypassing filter", (Object)this.getName(), (Object)e);
            return inData;
        }
    }
}

