/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.bundle;

import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.interpolator.Interpolator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivator<M extends Mediator>
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActivator.class);
    protected M mediator;

    public abstract void doStart() throws Exception;

    public abstract void doStop() throws Exception;

    public abstract M doInstantiate(BundleContext var1);

    protected void injectPropertyFields() throws Exception {
        LOG.debug("Starting introspection in bundle %s", (Object)((Mediator)this.mediator).getContext().getBundle().getSymbolicName());
        Interpolator interpolator = new Interpolator((Mediator)this.mediator);
        interpolator.getInstance(this);
        for (Map.Entry<String, String> entry : interpolator.getPropertiesInjected().entrySet()) {
            if (((Mediator)this.mediator).properties.containsKey(entry.getKey())) continue;
            ((Mediator)this.mediator).properties.put(entry.getKey(), entry.getValue());
        }
    }

    public void start(BundleContext context) throws Exception {
        this.mediator = this.initMediator(context);
        try {
            this.injectPropertyFields();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.doStart();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.doStop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mediator != null) {
            ((Mediator)this.mediator).deactivate();
        }
        this.mediator = null;
    }

    protected M initMediator(BundleContext context) {
        M mediator = this.doInstantiate(context);
        return mediator;
    }
}

