/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import org.eclipse.sensinact.gateway.util.json.JSONArrayStatement;
import org.eclipse.sensinact.gateway.util.json.JSONObjectStatement;
import org.eclipse.sensinact.gateway.util.json.JSONStatement;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONTokenerStatement
extends JSONTokener {
    public JSONTokenerStatement(String json) {
        super(json);
    }

    @Override
    public Object nextValue() throws JSONException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return super.nextString(c);
            }
            case '$': {
                return this.nextVariable();
            }
            case '{': {
                super.back();
                return new JSONObjectStatement(this);
            }
            case '[': {
                super.back();
                return new JSONArrayStatement(this);
            }
        }
        StringBuffer sb = new StringBuffer();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = super.next();
        }
        super.back();
        String string = sb.toString().trim();
        if ("".equals(string)) {
            throw super.syntaxError("Missing value");
        }
        return JSONObject.stringToValue(string);
    }

    public JSONStatement.JSONVariable nextVariable() throws JSONException {
        char c = this.next();
        if (c != '(') {
            throw this.syntaxError("Variable name pattern : ^\\$\\([^\\(\\)\\\\]+\\$)");
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '(': 
                case '\\': {
                    throw this.syntaxError("Variable name pattern : ^\\$\\([^\\(\\)\\\\]+\\$)");
                }
                case ')': {
                    return new JSONStatement.JSONVariable(sb.toString());
                }
            }
            sb.append(c);
        }
    }
}

