/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.RegisteringResponse;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.RestAccessConstants;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet
public class HttpRegisteringEndpoint
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRegisteringEndpoint.class);
    private NorthboundMediator mediator;

    public HttpRegisteringEndpoint(NorthboundMediator mediator) {
        this.mediator = mediator;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doExecute(request, response);
    }

    private final void doExecute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        try {
            String queryString = request.getQueryString();
            if (queryString == null) {
                response.sendError(400, "'create' or 'renew' request parameter expected");
            }
            String query = null;
            Map map = NorthboundRequest.processRequestQuery((String)queryString);
            Set queryKeys = map.keySet();
            for (NorthboundRequestWrapper.QueryKey queryKey : queryKeys) {
                switch (queryKey.name) {
                    case "request": {
                        Object list = (List)map.get(queryKey);
                        if (list == null) break;
                        query = (String)list.get(list.size() - 1);
                        break;
                    }
                    case "create": 
                    case "renew": {
                        query = queryKey.name;
                        break;
                    }
                }
                if (query == null) continue;
                break;
            }
            if (query == null) {
                response.sendError(400, "'create' or 'renew' request parameter expected");
            }
            byte[] content = IOUtils.read((InputStream)request.getInputStream(), (boolean)false);
            JSONObject jcontent = new JSONObject(new String(content));
            RegisteringResponse registeringResponse = null;
            switch (query) {
                case "create": {
                    String login = (String)jcontent.opt("login");
                    String password = (String)jcontent.opt("password");
                    String account = (String)jcontent.opt("account");
                    String accountType = (String)jcontent.opt("accountType");
                    registeringResponse = this.mediator.getAccessingEndpoint().registeringEndpoint(login, password, account, accountType);
                    break;
                }
                case "renew": {
                    String account = (String)jcontent.opt("account");
                    registeringResponse = this.mediator.getAccessingEndpoint().passwordRenewingEndpoint(account);
                    break;
                }
                default: {
                    response.sendError(400, "'create' or 'renew' request parameter expected");
                }
            }
            byte[] resultBytes = registeringResponse.getJSON().getBytes();
            response.setContentType(RestAccessConstants.JSON_CONTENT_TYPE);
            response.setContentLength(resultBytes.length);
            response.setBufferSize(resultBytes.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(resultBytes);
            response.setStatus(200);
        }
        catch (ClassCastException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(400, "Invalid parameters type");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(520, "Internal server error");
        }
    }
}

