/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.osgi;

import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sensinact.gateway.protocol.ssdp.discovery.SSDPAbstractListenerThread;
import org.eclipse.sensinact.gateway.protocol.ssdp.discovery.SSDPDiscoveryListenerThread;
import org.eclipse.sensinact.gateway.protocol.ssdp.discovery.SSDPMulticastListenerThread;
import org.eclipse.sensinact.gateway.protocol.ssdp.listener.SSDPDiscoveryNotifier;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    private List<SSDPAbstractListenerThread> discoveryThreads;
    private SSDPDiscoveryNotifier notifier;

    public void start(BundleContext context) throws Exception {
        this.discoveryThreads = new ArrayList<SSDPAbstractListenerThread>();
        this.notifier = new SSDPDiscoveryNotifier(context);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
            this.discoveryThreads.add(new SSDPDiscoveryListenerThread(this.notifier, networkInterface));
            this.discoveryThreads.add(new SSDPMulticastListenerThread(this.notifier, networkInterface));
        }
    }

    public void stop(BundleContext context) throws Exception {
        for (SSDPAbstractListenerThread discoveryThread : this.discoveryThreads) {
            discoveryThread.stop();
        }
        this.notifier.stop(context);
    }
}

