/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.ModelAlreadyRegisteredException;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.MutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.SecuredAccess;
import org.eclipse.sensinact.gateway.security.signature.api.BundleValidation;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInstanceBuilder<C extends ModelConfiguration, I extends ModelInstance<C>> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelInstanceBuilder.class);
    protected Mediator mediator;

    public ModelInstanceBuilder(Mediator mediator) {
        this.mediator = mediator;
    }

    protected void buildAccessNode(final MutableAccessTree<? extends MutableAccessNode> accessTree, final String name) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                final String identifier = (String)ModelInstanceBuilder.this.mediator.callService(BundleValidation.class, (Executable)new Executable<BundleValidation, String>(){

                    public String execute(BundleValidation service) throws Exception {
                        return service.check(ModelInstanceBuilder.this.mediator.getContext().getBundle());
                    }
                });
                if (identifier == null) {
                    accessTree.add(UriUtils.getUri((String[])new String[]{name})).withAccessProfile(AccessProfileOption.ALL_ANONYMOUS.getAccessProfile());
                } else {
                    ModelInstanceBuilder.this.mediator.callService(SecuredAccess.class, (Executable)new Executable<SecuredAccess, Void>(){

                        public Void execute(SecuredAccess service) throws Exception {
                            service.buildAccessNodesHierarchy(identifier, name, accessTree);
                            return null;
                        }
                    });
                }
                return null;
            }
        });
    }

    public I build(String name, String profileId, C modelConfiguration) {
        ModelInstance instance = null;
        if (modelConfiguration != null) {
            this.buildAccessNode(((ModelConfiguration)modelConfiguration).getAccessTree(), name);
            Class ci = ((ModelConfiguration)modelConfiguration).getModelInstanceType();
            instance = ci != null ? (ModelInstance)ReflectUtils.getInstance(ModelInstance.class, ci, (Object[])new Object[]{this.mediator, modelConfiguration, name, profileId}) : (ModelInstance)ReflectUtils.getInstance(ModelInstance.class, (Object[])new Object[]{this.mediator, modelConfiguration, name, profileId});
            try {
                this.register(instance);
            }
            catch (ModelAlreadyRegisteredException e) {
                LOG.error("Model instance '%s' already exists", (Object)name);
                instance = null;
            }
        }
        return (I)instance;
    }

    protected final void register(I instance) {
        if (instance == null) {
            return;
        }
        ((ModelInstance)instance).register();
    }
}

