/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.StringPatternValue;

public class RequirementBuilder
implements Nameable,
Iterable<Map.Entry<String, Object>> {
    protected final AttributeBuilder.Requirement requirement;
    protected final String attributeName;
    protected final Map<String, Object> values;

    public RequirementBuilder(AttributeBuilder.Requirement requirement, String attributeName) {
        this.requirement = requirement;
        this.attributeName = attributeName;
        this.values = new HashMap<String, Object>();
    }

    public void put(Object value) {
        this.put("#ANY_TARGET#", value);
    }

    public void put(String service, Object value) {
        Object val;
        Object object = val = value != null && value.getClass() == String.class ? new StringPatternValue((String)value) : value;
        if (service == null || service.length() == 0) {
            this.values.put("#ANY_TARGET#", val);
        } else {
            this.values.put(service, val);
        }
    }

    public Object get(String service) {
        Object value = this.values.get(service);
        if (value == null && service.intern() != "#ANY_TARGET#".intern()) {
            value = this.values.get("#ANY_TARGET#");
        }
        return value;
    }

    public void apply(String service, List<AttributeBuilder> builders) {
        builders.stream().filter(b -> this.attributeName.equals(b.getName())).findFirst().ifPresent(b -> this.apply(service, (AttributeBuilder)b));
    }

    public void apply(String service, AttributeBuilder builder) {
        Object value = this.get(service);
        if (value == null || !this.attributeName.equals(builder.getName())) {
            return;
        }
        if (value instanceof StringPatternValue) {
            value = this.attributeName.equals("name") ? ((StringPatternValue)value).getLast() : ((StringPatternValue)value).build();
        }
        switch (this.requirement) {
            case HIDDEN: {
                builder.hidden((Boolean)value);
                break;
            }
            case MODIFIABLE: {
                builder.modifiable((Modifiable)value);
                break;
            }
            case TYPE: {
                builder.type((Class)value);
                break;
            }
            case VALUE: {
                builder.value(value);
                break;
            }
        }
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (RequirementBuilder.class.isAssignableFrom(objectClass)) {
            RequirementBuilder builder = (RequirementBuilder)object;
            return this.equals(builder.attributeName) && this.equals((Object)builder.requirement);
        }
        if (String.class == objectClass) {
            return object.equals(this.attributeName);
        }
        if (AttributeBuilder.Requirement.class.isAssignableFrom(objectClass)) {
            return object.equals((Object)this.requirement);
        }
        return false;
    }

    public String getName() {
        return this.attributeName;
    }
}

