/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.AttributeDescription;
import org.eclipse.sensinact.gateway.core.InvalidAttributeException;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.LinkedResourceImpl;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaNotificationMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.ActMethod;
import org.eclipse.sensinact.gateway.core.method.GetMethod;
import org.eclipse.sensinact.gateway.core.method.LinkedActMethod;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.SetMethod;
import org.eclipse.sensinact.gateway.core.method.Shortcut;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.method.SubscribeMethod;
import org.eclipse.sensinact.gateway.core.method.UnsubscribeMethod;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBuilder.class);
    private static final AccessMethod.Type GET = AccessMethod.Type.valueOf(AccessMethod.GET);
    private static final AccessMethod.Type SET = AccessMethod.Type.valueOf(AccessMethod.SET);
    private static final AccessMethod.Type ACT = AccessMethod.Type.valueOf(AccessMethod.ACT);
    private static final AccessMethod.Type SUBSCRIBE = AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE);
    private static final AccessMethod.Type UNSUBSCRIBE = AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE);
    private static final AccessMethod.Type DESCRIBE = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
    protected final Mediator mediator;
    protected final ResourceConfig resourceConfig;

    public ResourceBuilder(Mediator mediator, ResourceConfig resourceConfig) {
        this.mediator = mediator;
        this.resourceConfig = resourceConfig;
    }

    public void configureName(String name) {
        RequirementBuilder builder = new RequirementBuilder(AttributeBuilder.Requirement.VALUE, "name");
        builder.put("#ANY_TARGET#", name);
        this.resourceConfig.addRequirementBuilder(builder);
    }

    public String getConfiguredName() {
        return this.resourceConfig.getName();
    }

    public void configureType(Class<?> type) {
        this.configureRequirement("value", AttributeBuilder.Requirement.TYPE, type);
    }

    public void configureValue(Object value) {
        if (value == null) {
            return;
        }
        this.configureRequirement("value", AttributeBuilder.Requirement.VALUE, value);
    }

    public void configureRequirement(String attributeName, AttributeBuilder.Requirement requirement, Object value) {
        RequirementBuilder builder = new RequirementBuilder(requirement, attributeName);
        builder.put(value);
        this.resourceConfig.addRequirementBuilder(builder);
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public ResourceImpl build(ModelInstance<?> modelInstance, ServiceImpl service) throws InvalidResourceException {
        String name = this.getConfiguredName();
        if (name == null) {
            throw new InvalidResourceException("Resource's name is needed");
        }
        TypeConfig typeConfig = this.getResourceConfig().getTypeConfig();
        ResourceImpl resourceImpl = (ResourceImpl)ReflectUtils.getInstance(typeConfig.getResourceBaseClass(), typeConfig.getResourceImplementedClass(), (Object[])new Object[]{modelInstance, this.getResourceConfig(), service});
        if (resourceImpl == null) {
            throw new InvalidResourceException(String.format("Unable to create the resource : %s", name));
        }
        if (!resourceImpl.isHidden()) {
            try {
                this.buildMethods(resourceImpl);
            }
            catch (InvalidValueException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                throw new InvalidResourceException("Error while creating methods", e);
            }
        }
        return resourceImpl;
    }

    public ResourceImpl buildLinkedResource(ServiceImpl service, ResourceImpl target) throws InvalidResourceException {
        if (target == null) {
            throw new InvalidResourceException("Target resource is needed");
        }
        LinkedResourceImpl linkedResourceImpl = new LinkedResourceImpl((ModelInstance<?>)target.getModelInstance(), this.getResourceConfig(), target, service);
        try {
            this.buildMethods(linkedResourceImpl);
        }
        catch (InvalidValueException e) {
            throw new InvalidResourceException(e.getMessage(), e);
        }
        return linkedResourceImpl;
    }

    public ResourceImpl buildLinkedActionResource(ServiceImpl service, ResourceImpl target, boolean copyActMethod) throws InvalidResourceException {
        LinkedResourceImpl linkedResourceImpl = (LinkedResourceImpl)this.buildLinkedResource(service, target);
        LinkedActMethod actMethod = null;
        actMethod = new LinkedActMethod(this.mediator, linkedResourceImpl.getPath(), (ActMethod)target.getAccessMethod(ACT), copyActMethod);
        linkedResourceImpl.registerMethod(ACT, actMethod);
        return linkedResourceImpl;
    }

    protected final void buildMethods(ResourceImpl resource) throws InvalidResourceException, InvalidValueException {
        if (resource == null) {
            return;
        }
        GetMethod getMethod = null;
        Signature getSignature = null;
        SetMethod setMethod = null;
        Signature setSignature = null;
        SubscribeMethod subscribeMethod = null;
        Signature subscribeSignature = null;
        UnsubscribeMethod unsubscribeMethod = null;
        Signature unsubscribeSignature = null;
        getMethod = new GetMethod(this.mediator, resource.getPath(), this.getPreProcessingExecutor(resource, AccessMethod.GET));
        getSignature = new Signature(this.mediator, GET, new Class[]{String.class}, new String[]{"attributeName"});
        setMethod = new SetMethod(this.mediator, resource.getPath(), this.getPreProcessingExecutor(resource, AccessMethod.SET));
        setSignature = new Signature(this.mediator, SET, new Class[]{String.class, Object.class}, new String[]{"attributeName", "value"});
        subscribeMethod = new SubscribeMethod(this.mediator, resource.getPath(), this.getPreProcessingExecutor(resource, AccessMethod.SUBSCRIBE));
        subscribeSignature = new Signature(this.mediator, SUBSCRIBE, new Class[]{String.class, Recipient.class, Set.class, String.class}, new String[]{"attributeName", "listener", "conditions", "policy"});
        unsubscribeMethod = new UnsubscribeMethod(this.mediator, resource.getPath(), this.getPreProcessingExecutor(resource, AccessMethod.UNSUBSCRIBE));
        unsubscribeSignature = new Signature(this.mediator, UNSUBSCRIBE, new Class[]{String.class, String.class}, new String[]{"attributeName", "subscriptionId"});
        getMethod.addSignature(getSignature, this.getExecutor(resource), AccessMethodExecutor.ExecutionPolicy.BEFORE);
        Enumeration<Attribute> attrs = resource.attributes();
        while (attrs.hasMoreElements()) {
            if (!Modifiable.MODIFIABLE.equals((Object)attrs.nextElement().getModifiable())) continue;
            setMethod.addSignature(setSignature, this.setExecutor(resource), AccessMethodExecutor.ExecutionPolicy.BEFORE);
            break;
        }
        subscribeMethod.addSignature(subscribeSignature, this.subscribeExecutor(resource), AccessMethodExecutor.ExecutionPolicy.BEFORE);
        unsubscribeMethod.addSignature(unsubscribeSignature, this.unsubscribeExecutor(resource), AccessMethodExecutor.ExecutionPolicy.BEFORE);
        Parameter conditionsParameter = new Parameter(this.mediator, "conditions", Set.class);
        conditionsParameter.setValue(Collections.emptySet());
        Parameter policyParameter = new Parameter(this.mediator, "policy", String.class);
        policyParameter.setValue(String.valueOf(0x100010));
        HashMap<Integer, Parameter> fixedPolicyParameters = new HashMap<Integer, Parameter>();
        fixedPolicyParameters = new HashMap();
        fixedPolicyParameters.put(3, policyParameter);
        Shortcut subscribePolicyShortcut = new Shortcut(this.mediator, SUBSCRIBE, new Class[]{String.class, Recipient.class, Set.class}, new String[]{"attributeName", "listener", "conditions"}, fixedPolicyParameters);
        subscribeMethod.addShortcut(subscribePolicyShortcut, subscribeSignature);
        HashMap<Integer, Parameter> fixedConditionsParameters = new HashMap<Integer, Parameter>();
        fixedConditionsParameters.put(2, conditionsParameter);
        Shortcut subscribeConditionsAndPolicyShortcut = new Shortcut(this.mediator, SUBSCRIBE, new Class[]{String.class, Recipient.class}, new String[]{"attributeName", "listener"}, fixedConditionsParameters);
        subscribeMethod.addShortcut(subscribeConditionsAndPolicyShortcut, subscribePolicyShortcut);
        String resourceDefaultAttribute = resource.getDefault();
        if (resourceDefaultAttribute != null) {
            Parameter nameParameter = new Parameter(this.mediator, "attributeName", String.class);
            nameParameter.setValue(resourceDefaultAttribute);
            HashMap<Integer, Parameter> fixedNameParameter = new HashMap<Integer, Parameter>();
            fixedNameParameter.put(0, nameParameter);
            Shortcut getAttributeShortcut = new Shortcut(this.mediator, GET, new Class[0], new String[0], fixedNameParameter);
            getMethod.addShortcut(getAttributeShortcut, getSignature);
            Attribute defaultAttribute = resource.getAttribute(resourceDefaultAttribute);
            if (defaultAttribute != null && Modifiable.MODIFIABLE.equals((Object)defaultAttribute.getModifiable())) {
                Shortcut setAttributeShortcut = new Shortcut(this.mediator, SET, new Class[]{Object.class}, new String[]{"value"}, fixedNameParameter);
                setMethod.addShortcut(setAttributeShortcut, setSignature);
            }
            Shortcut subscribeNameConditionsAndPolicyShortcut = new Shortcut(this.mediator, SUBSCRIBE, new Class[]{Recipient.class}, new String[]{"listener"}, fixedNameParameter);
            Shortcut subscribeNameAndPolicyShortcut = new Shortcut(this.mediator, SUBSCRIBE, new Class[]{Recipient.class, Set.class}, new String[]{"listener", "conditions"}, fixedNameParameter);
            Shortcut subscribeNameShortcut = new Shortcut(this.mediator, SUBSCRIBE, new Class[]{Recipient.class, Set.class, String.class}, new String[]{"listener", "conditions", "policy"}, fixedNameParameter);
            subscribeMethod.addShortcut(subscribeNameConditionsAndPolicyShortcut, subscribeConditionsAndPolicyShortcut);
            subscribeMethod.addShortcut(subscribeNameAndPolicyShortcut, subscribePolicyShortcut);
            subscribeMethod.addShortcut(subscribeNameShortcut, subscribeSignature);
            Shortcut unsubscribeNameShortcut = new Shortcut(this.mediator, UNSUBSCRIBE, new Class[]{String.class}, new String[]{"subscriptionId"}, fixedNameParameter);
            unsubscribeMethod.addShortcut(unsubscribeNameShortcut, unsubscribeSignature);
        }
        if (ActionResource.class.isAssignableFrom(resource.getResourceType()) && !LinkedResourceImpl.class.isAssignableFrom(resource.getClass())) {
            ActMethod actMethod = new ActMethod(this.mediator, resource.getPath(), this.getPreProcessingExecutor(resource, AccessMethod.ACT), this.getActPostProcessingExecutor(resource));
            resource.registerMethod(ACT, actMethod);
        }
        resource.registerMethod(GET, getMethod);
        resource.registerMethod(SET, setMethod);
        resource.registerMethod(SUBSCRIBE, subscribeMethod);
        resource.registerMethod(UNSUBSCRIBE, unsubscribeMethod);
    }

    private AccessMethodExecutor getPreProcessingExecutor(final ResourceImpl resource, final String type) {
        return new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder parameter) throws Exception {
                Object resultObject = resource.passOn(type, resource.getPath(), parameter.getParameters());
                if (resultObject != null && resultObject != AccessMethod.EMPTY && JSONObject.class.isAssignableFrom(resultObject.getClass())) {
                    JSONObject result = (JSONObject)resultObject;
                    result.remove("taskId");
                    if (JSONObject.NULL.equals(result.opt("result"))) {
                        result.remove("result");
                    }
                    parameter.setAccessMethodObjectResult(result);
                }
                return null;
            }
        };
    }

    private AccessMethodExecutor getActPostProcessingExecutor(final ResourceImpl resource) {
        return new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder parameter) throws Exception {
                SnaUpdateMessage message = (SnaUpdateMessage)SnaNotificationMessageImpl.Builder.notification(ResourceBuilder.this.mediator, SnaUpdateMessage.Update.ACTUATED, resource.getPath());
                JSONObject notification = new JSONObject();
                notification.put("timestamp", System.currentTimeMillis());
                notification.put("type", (Object)"object");
                notification.put("value", parameter.getAccessMethodObjectResult());
                message.setNotification(notification);
                ((ModelInstance)resource.getModelInstance()).postMessage(message);
                return null;
            }
        };
    }

    private final AccessMethodExecutor getExecutor(final ResourceImpl resource) {
        return new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder snaResult) throws Exception {
                JSONObject result = null;
                AttributeDescription description = resource.getDescription((String)snaResult.getParameter(0));
                if (description != null) {
                    result = new JSONObject(description.getJSON());
                    snaResult.setAccessMethodObjectResult(result);
                }
                return null;
            }
        };
    }

    private final AccessMethodExecutor setExecutor(final ResourceImpl resource) {
        return new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder snaResult) throws Exception {
                Object[] parameters = snaResult.getParameters();
                int length = parameters == null ? 0 : parameters.length;
                AttributeDescription desc = resource.set((String)parameters[0], parameters[1]);
                JSONObject result = new JSONObject(desc.getJSON());
                snaResult.setAccessMethodObjectResult(result);
                return null;
            }
        };
    }

    private final AccessMethodExecutor subscribeExecutor(final ResourceImpl resource) {
        return new AccessMethodExecutor(){

            /*
             * Unable to fully structure code
             */
            public Void execute(AccessMethodResponseBuilder snaResult) throws Exception {
                attributeName = (String)snaResult.getParameter(0);
                attribute = resource.getAttribute(attributeName);
                if (attribute == null) {
                    throw new InvalidAttributeException("unknown attribute :" + attributeName);
                }
                parameters = snaResult.getParameters();
                if (parameters == null || parameters.length < 2) {
                    throw new IllegalArgumentException("Minimum set of parameters expected: attribute name and recipient");
                }
                recipient = null;
                conditions = null;
                type = null;
                policy = 0x100010;
                lifetime = 0L;
                buffer = 0;
                delay = 0;
                switch (parameters.length) {
                    case 8: {
                        buffer = (Integer)parameters[6];
                        delay = (Integer)parameters[7];
                    }
                    case 6: {
                        lifetime = (Long)parameters[5];
                    }
                    case 5: {
                        type = (MidCallback.Type)parameters[4];
                    }
                    case 4: {
                        if (parameters[3].getClass() != String.class) ** GOTO lbl78
                        try {
                            policy = Integer.parseInt((String)parameters[3]);
                            ** GOTO lbl79
                        }
                        catch (NumberFormatException e) {
                            policy = 0;
                            policies = ((String)parameters[3]).split("|");
                            block26: for (index = 0; index < policies.length; ++index) {
                                var16_16 = policies[index].trim();
                                var17_17 = -1;
                                switch (var16_16.hashCode()) {
                                    case 215424167: {
                                        if (!var16_16.equals("CONTINUE")) break;
                                        var17_17 = 0;
                                        break;
                                    }
                                    case 0x270002: {
                                        if (!var16_16.equals("STOP")) break;
                                        var17_17 = 1;
                                        break;
                                    }
                                    case 522907364: {
                                        if (!var16_16.equals("ROLLBACK")) break;
                                        var17_17 = 2;
                                        break;
                                    }
                                    case -2137067054: {
                                        if (!var16_16.equals("IGNORE")) break;
                                        var17_17 = 3;
                                        break;
                                    }
                                    case 1956166541: {
                                        if (!var16_16.equals("ALTERNATIVE")) break;
                                        var17_17 = 4;
                                        break;
                                    }
                                    case 75556: {
                                        if (!var16_16.equals("LOG")) break;
                                        var17_17 = 5;
                                    }
                                }
                                switch (var17_17) {
                                    case 0: {
                                        policy |= 1;
                                        continue block26;
                                    }
                                    case 1: {
                                        policy |= 16;
                                        continue block26;
                                    }
                                    case 2: {
                                        policy |= 256;
                                        continue block26;
                                    }
                                    case 3: {
                                        policy |= 4096;
                                        continue block26;
                                    }
                                    case 4: {
                                        policy |= 65536;
                                        continue block26;
                                    }
                                    case 5: {
                                        policy |= 0x100000;
                                    }
                                }
                            }
                        }
                        ** GOTO lbl79
lbl78:
                        // 1 sources

                        policy = (Integer)parameters[3];
                    }
lbl79:
                    // 4 sources

                    case 3: {
                        conditions = (Set)parameters[2];
                    }
                    case 2: {
                        recipient = (Recipient)parameters[1];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameters");
                    }
                }
                callbackId = resource.listen(attributeName, recipient, conditions, policy, type, lifetime, buffer, delay);
                if (callbackId != null) {
                    result = new JSONObject();
                    result.put("subscriptionId", (Object)callbackId);
                    result.put("initial", (Object)new JSONObject(attribute.getDescription().getJSON()));
                    snaResult.setAccessMethodObjectResult(result);
                }
                return null;
            }
        };
    }

    private final AccessMethodExecutor unsubscribeExecutor(final ResourceImpl resource) {
        return new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder result) throws Exception {
                String attributeName = (String)result.getParameter(0);
                Attribute attribute = resource.getAttribute(attributeName);
                if (attribute == null) {
                    throw new InvalidAttributeException("unknown attribute :" + attributeName);
                }
                resource.unlisten((String)result.getParameter(1));
                result.setAccessMethodObjectResult(new JSONObject().put("message", (Object)"unsubscription done"));
                return null;
            }
        };
    }
}

