/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.primitive.Description;
import org.eclipse.sensinact.gateway.common.primitive.ElementsProxy;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Localizable;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Stateful;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.LifecycleStatusListener;
import org.eclipse.sensinact.gateway.core.LocationResource;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelElement;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceBuilder;
import org.eclipse.sensinact.gateway.core.ServiceCollection;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProcessableData;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.ServiceProviderProcessableData;
import org.eclipse.sensinact.gateway.core.ServiceProviderProxy;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderImpl
extends ModelElement<ModelInstance<?>, ServiceProviderProxy, ServiceProviderProcessableData<?>, ServiceImpl, Service>
implements Localizable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceProviderImpl.class);
    protected List<LifecycleStatusListener> listeners;
    protected List<String> serviceNames;

    public ServiceProviderImpl(ModelInstance<?> modelInstance, String name) throws InvalidServiceProviderException {
        this(modelInstance, name, Collections.emptyList());
    }

    public ServiceProviderImpl(ModelInstance<?> modelInstance, String name, List<String> serviceNames) throws InvalidServiceProviderException {
        super(modelInstance, null, UriUtils.getUri((String[])new String[]{name}));
        this.serviceNames = new ArrayList<String>(serviceNames);
        try {
            this.createAdministrationService();
        }
        catch (Exception e) {
            throw new InvalidServiceProviderException(e);
        }
        this.listeners = new ArrayList<LifecycleStatusListener>();
        this.listeners.add((LifecycleStatusListener)this.modelInstance);
    }

    @Override
    public void process(ServiceProviderProcessableData<?> data) {
        if (data == null) {
            return;
        }
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            ServiceProcessableData serviceProcessableData = (ServiceProcessableData)iterator.next();
            String serviceId = serviceProcessableData.getServiceId();
            if (serviceId == null) continue;
            ServiceImpl service = (ServiceImpl)super.element(serviceId);
            if (service == null) {
                try {
                    service = this.addService(serviceId);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (service == null) {
                LOG.warn("Service '%s' not found", (Object)serviceId);
                continue;
            }
            service.process(serviceProcessableData);
        }
    }

    public ServiceImpl getAdminService() {
        return this.getService("admin");
    }

    public ServiceImpl getService(String service) {
        return (ServiceImpl)super.element(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceImpl> getServices() {
        List list = this.elements;
        synchronized (list) {
            return Collections.unmodifiableList(this.elements);
        }
    }

    public String getLocation() {
        return (String)this.getAdminService().getResource("location").getAttribute("value").getValue();
    }

    public String setLocation(String location) throws InvalidValueException {
        return (String)this.getAdminService().getResource("location").getAttribute("value").setValue(location);
    }

    public ServiceProvider.LifecycleStatus getStatus() {
        return (ServiceProvider.LifecycleStatus)((Object)this.getAdminService().getResource("lifecycleStatus").getAttribute("value").getValue());
    }

    public ServiceProvider.LifecycleStatus setStatus(ServiceProvider.LifecycleStatus status) {
        Attribute attribute = this.getAdminService().getResource("lifecycleStatus").getAttribute("value");
        if (status != null) {
            try {
                int length;
                ServiceProvider.LifecycleStatus newStatus = (ServiceProvider.LifecycleStatus)((Object)attribute.setValue((Object)status));
                int n = length = this.listeners == null ? 0 : this.listeners.size();
                for (int index = 0; index < length; ++index) {
                    this.listeners.get(index).update(newStatus);
                }
            }
            catch (InvalidValueException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return (ServiceProvider.LifecycleStatus)((Object)attribute.getValue());
    }

    protected ServiceImpl createAdministrationService() throws InvalidServiceException, InvalidResourceException, InvalidValueException {
        ResourceConfig rc;
        ServiceBuilder builder = ((ModelInstance)this.modelInstance).getServiceBuilder();
        builder.configureName("admin");
        ServiceImpl admin = this.addService(builder);
        byte buildPolicy = (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy());
        String profile = ((ModelInstance)this.modelInstance).getProfile();
        if (profile == null) {
            profile = "#ANY_PROFILE#";
        }
        List<ResourceConfig> resourceConfigs = ((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceConfigs(profile, "admin");
        if (admin.getResource("lifecycleStatus") == null) {
            ResourceBuilder statusResourceBuilder = ((ModelInstance)super.getModelInstance()).getResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceType(PropertyResource.class).withResourceName("lifecycleStatus").withDataType(ServiceProvider.LifecycleStatus.class).withDataValue((Object)ServiceProvider.LifecycleStatus.INACTIVE).withHidden(true).withUpdatePolicy(Resource.UpdatePolicy.AUTO).withModifiable(Modifiable.UPDATABLE).withProfile(profile), buildPolicy);
            statusResourceBuilder.configureName("lifecycleStatus");
            admin.addResource(statusResourceBuilder);
        }
        if (admin.getResource("friendlyName") == null) {
            ResourceBuilder friendlyNameResourceBuilder = null;
            rc = resourceConfigs.stream().filter(r -> "friendlyName".equals(r.getName())).findFirst().orElse(null);
            friendlyNameResourceBuilder = rc != null ? ((ModelInstance)super.getModelInstance()).getResourceBuilder(rc) : ((ModelInstance)super.getModelInstance()).getResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceType(PropertyResource.class).withResourceName("friendlyName").withDataType(String.class).withHidden(false).withUpdatePolicy(Resource.UpdatePolicy.AUTO).withModifiable(Modifiable.MODIFIABLE).withProfile(profile), buildPolicy);
            friendlyNameResourceBuilder.configureName("friendlyName");
            admin.addResource(friendlyNameResourceBuilder);
        }
        if (admin.getResource("location") == null) {
            String defaultLocation = ModelInstance.defaultLocation(((ModelInstance)this.modelInstance).mediator());
            ResourceBuilder locationResourceBuilder = null;
            ResourceConfig rc2 = resourceConfigs.stream().filter(r -> "location".equals(r.getName())).findFirst().orElse(null);
            locationResourceBuilder = rc2 != null ? ((ModelInstance)super.getModelInstance()).getResourceBuilder(rc2) : ((ModelInstance)super.getModelInstance()).getResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceType(LocationResource.class).withResourceName("location").withDataType(String.class).withDataValue(defaultLocation).withHidden(false).withModifiable(Modifiable.MODIFIABLE).withProfile(profile), buildPolicy);
            locationResourceBuilder.configureName("location");
            admin.addResource(locationResourceBuilder);
        }
        if (admin.getResource("bridge") == null) {
            ResourceBuilder bridgeResourceBuilder = null;
            try {
                bridgeResourceBuilder = ((ModelInstance)super.getModelInstance()).getResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceType(PropertyResource.class).withResourceName("bridge").withDataType(String.class).withDataValue(((ModelInstance)this.modelInstance).mediator().getContext().getBundle().getSymbolicName()).withHidden(false).withUpdatePolicy(Resource.UpdatePolicy.AUTO).withModifiable(Modifiable.FIXED).withProfile(profile), buildPolicy);
                bridgeResourceBuilder.configureName("bridge");
                admin.addResource(bridgeResourceBuilder);
            }
            catch (Exception e) {
                LOG.debug("Unable to create the 'bridge' resource");
                bridgeResourceBuilder = null;
            }
        }
        if (admin.getResource("icon") == null) {
            ResourceBuilder iconResourceBuilder = null;
            rc = resourceConfigs.stream().filter(r -> "icon".equals(r.getName())).findFirst().orElse(null);
            iconResourceBuilder = rc != null ? ((ModelInstance)super.getModelInstance()).getResourceBuilder(rc) : ((ModelInstance)super.getModelInstance()).getResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceType(PropertyResource.class).withResourceName("icon").withDataType(String.class).withHidden(false).withUpdatePolicy(Resource.UpdatePolicy.AUTO).withModifiable(Modifiable.MODIFIABLE).withProfile(profile), buildPolicy);
            iconResourceBuilder.configureName("icon");
            admin.addResource(iconResourceBuilder);
        }
        return admin;
    }

    public ServiceImpl addService(String serviceName) throws InvalidServiceException, InvalidResourceException, InvalidValueException {
        ServiceImpl service = null;
        service = this.getService(serviceName);
        if (service != null) {
            LOG.warn("'%s' service already exists", (Object)serviceName);
            return service;
        }
        byte buildPolicy = ((ModelConfiguration)((ModelInstance)this.getModelInstance()).configuration()).getServiceBuildPolicy();
        if (!SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED) && !this.serviceNames.contains(serviceName)) {
            LOG.warn("Incompatible build policy : unable to create the '%s' service", (Object)serviceName);
            return null;
        }
        ServiceBuilder builder = ((ModelInstance)this.modelInstance).getServiceBuilder();
        builder.configureName(serviceName);
        try {
            service = this.addService(builder);
        }
        catch (Exception e) {
            throw new InvalidServiceException(e);
        }
        buildPolicy = ((ModelConfiguration)((ModelInstance)this.getModelInstance()).configuration()).getResourceBuildPolicy();
        if (service != null && SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION)) {
            ResourceConfig defaultResourceConfig;
            List<ResourceConfig> resources = ((ModelConfiguration)((ModelInstance)this.modelInstance).configuration()).getResourceConfigs(((ModelInstance)this.modelInstance).getProfile(), serviceName);
            if (((ModelInstance)this.modelInstance).getProfile() != null && !"#ANY_PROFILE#".equals(((ModelInstance)this.modelInstance).getProfile())) {
                resources.addAll(((ModelConfiguration)((ModelInstance)this.modelInstance).configuration()).getResourceConfigs("#ANY_PROFILE#", serviceName));
            }
            if ((defaultResourceConfig = ((ModelConfiguration)((ModelInstance)this.modelInstance).configuration()).getDefaultResourceConfig(serviceName)) != null) {
                defaultResourceConfig.configureName(serviceName, serviceName);
            }
            if (resources == null) {
                resources = Collections.emptyList();
            }
            LOG.info("New service discovered for '%s' service provider : %s", (Object)this.name, (Object)serviceName);
            for (ResourceConfig resourceConfig : resources) {
                ResourceBuilder resourceBuilder = ((ModelInstance)this.modelInstance).getResourceBuilder(resourceConfig);
                if (resourceConfig != defaultResourceConfig) {
                    resourceConfig.configureName(serviceName, resourceConfig.getName().toLowerCase());
                }
                try {
                    service.addResource(resourceBuilder);
                }
                catch (InvalidResourceException e) {
                    throw new InvalidServiceException(e);
                }
            }
        }
        return service;
    }

    protected ServiceImpl addService(ServiceBuilder builder) throws InvalidServiceException, InvalidResourceException, InvalidValueException {
        ServiceImpl service = builder.build((ModelInstance<?>)this.modelInstance, this);
        if (service == null) {
            LOG.debug("Unable to create the service '%s'", (Object)builder.getConfiguredName());
            return null;
        }
        return super.addElement(service) ? service : null;
    }

    public boolean removeService(String serviceName) {
        ServiceImpl service = (ServiceImpl)super.removeElement(serviceName);
        if (service != null) {
            service.stop();
            return true;
        }
        return false;
    }

    @Override
    protected Class<? extends ElementsProxy<Service>> getProxyType() {
        return ServiceProvider.class;
    }

    @Override
    public void start() {
        if (!((ModelInstance)super.getModelInstance()).isRegistered()) {
            LOG.error("The resource model is not registered");
            return;
        }
        this.setStatus(ServiceProvider.LifecycleStatus.JOINING);
        try {
            super.start();
            this.doStart();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.stop();
            return;
        }
        this.setStatus(ServiceProvider.LifecycleStatus.ACTIVE);
        LOG.debug("ServiceProvider '%s' started", (Object)this.getName());
    }

    protected void doStart() throws Exception {
        byte buildPolicy = ((ModelConfiguration)((ModelInstance)this.modelInstance).configuration()).getServiceBuildPolicy();
        if (SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION)) {
            int length;
            int n = length = this.serviceNames == null ? 0 : this.serviceNames.size();
            for (int index = 0; index < length; ++index) {
                try {
                    this.addService(this.serviceNames.get(index));
                    continue;
                }
                catch (Exception e) {
                    throw new InvalidServiceProviderException(e);
                }
            }
        }
    }

    @Override
    public void stop() {
        this.setStatus(ServiceProvider.LifecycleStatus.LEAVING);
        try {
            super.stop();
            this.doStop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.setStatus(ServiceProvider.LifecycleStatus.INACTIVE);
    }

    protected void doStop() throws Exception {
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getRegisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.PROVIDER_APPEARING;
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getUnregisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.PROVIDER_DISAPPEARING;
    }

    @Override
    public ServiceProviderProxy getProxy(List<MethodAccessibility> methodAccessibilities) {
        return new ServiceProviderProxy(((ModelInstance)this.modelInstance).mediator(), super.getName());
    }

    @Override
    protected Service getElementProxy(AccessTree<?> tree, ServiceImpl element) throws ModelElementProxyBuildException {
        Service service = (Service)element.getProxy(tree);
        return service;
    }

    @Override
    protected ModelElement.ModelElementProxyWrapper getWrapper(ServiceProviderProxy proxy, ImmutableAccessTree tree) {
        return new ServiceProviderProxyWrapper(proxy, tree);
    }

    class ServiceProviderProxyWrapper
    extends ModelElement.ModelElementProxyWrapper
    implements ServiceCollection,
    Localizable,
    Stateful<ServiceProvider.LifecycleStatus> {
        protected ServiceProviderProxyWrapper(ServiceProviderProxy proxy, ImmutableAccessTree tree) {
            super((ModelElement)ServiceProviderImpl.this, (ModelElementProxy)proxy, tree);
        }

        @Override
        public List<Service> getServices() {
            return super.list();
        }

        @Override
        public Service getService(String service) {
            return (Service)super.element(service);
        }

        public String getLocation() {
            String location = null;
            Service admin = this.getService("admin");
            if (admin != null) {
                JSONObject response = (JSONObject)admin.get("location", "value", new Object[0]).getResponse();
                location = String.valueOf(response.opt("value"));
            }
            return location;
        }

        public String setLocation(String location) throws InvalidValueException {
            String setLocation = null;
            Service admin = this.getService("admin");
            if (admin != null) {
                JSONObject response = (JSONObject)admin.set("location", "value", location, new Object[0]).getResponse();
                setLocation = String.valueOf(response.opt("value"));
            }
            return setLocation;
        }

        public ServiceProvider.LifecycleStatus getStatus() {
            ServiceProvider.LifecycleStatus status = null;
            Service admin = this.getService("admin");
            if (admin != null) {
                JSONObject response = (JSONObject)admin.get("lifecycleStatus", "value", new Object[0]).getResponse();
                status = ServiceProvider.LifecycleStatus.valueOf(String.valueOf(response.opt("value")));
            }
            return status;
        }

        public ServiceProvider.LifecycleStatus setStatus(ServiceProvider.LifecycleStatus status) throws InvalidValueException {
            ServiceProvider.LifecycleStatus setStatus = null;
            Service admin = this.getService("admin");
            if (admin != null) {
                JSONObject response = (JSONObject)admin.set("lifecycleStatus", "value", (Object)status, new Object[0]).getResponse();
                setStatus = ServiceProvider.LifecycleStatus.valueOf(String.valueOf(response.opt("value")));
            }
            return setStatus;
        }

        public boolean isAccessible() {
            return true;
        }

        public Description getDescription() {
            return new Description(){

                public String getName() {
                    return ServiceProviderImpl.this.getName();
                }

                public String getJSON() {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append('{');
                    buffer.append('\"');
                    buffer.append("name");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(this.getName());
                    buffer.append('\"');
                    buffer.append(',');
                    buffer.append('\"');
                    buffer.append("services");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('[');
                    int index = 0;
                    Enumeration enumeration = ServiceProviderProxyWrapper.this.elements();
                    while (enumeration.hasMoreElements()) {
                        buffer.append(index > 0 ? Character.valueOf(',') : "");
                        buffer.append('\"');
                        buffer.append(((Service)enumeration.nextElement()).getName());
                        buffer.append('\"');
                        ++index;
                    }
                    buffer.append(']');
                    buffer.append('}');
                    return buffer.toString();
                }

                public String getJSONDescription() {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append('{');
                    buffer.append('\"');
                    buffer.append("name");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(this.getName());
                    buffer.append('\"');
                    buffer.append(',');
                    buffer.append('\"');
                    buffer.append("services");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('[');
                    int index = 0;
                    Enumeration enumeration = ServiceProviderProxyWrapper.this.elements();
                    while (enumeration.hasMoreElements()) {
                        buffer.append(index > 0 ? Character.valueOf(',') : "");
                        buffer.append('\"');
                        buffer.append(((Service)enumeration.nextElement()).getDescription().getJSONDescription());
                        buffer.append('\"');
                        ++index;
                    }
                    buffer.append(']');
                    buffer.append('}');
                    return buffer.toString();
                }
            };
        }
    }
}

