/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.message.AbstractMidCallback;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;

public abstract class AbstractMidAgentCallback
extends AbstractMidCallback
implements MidAgentCallback {
    protected static final String[] UNLISTENED = new String[]{"/sensiNact/system", "/AppManager/admin"};
    private Map<String, String> locations = new HashMap<String, String>();
    private final boolean propagate;

    protected AbstractMidAgentCallback() {
        this(true, true);
    }

    protected AbstractMidAgentCallback(String identifier) {
        this(true, true, identifier);
    }

    protected AbstractMidAgentCallback(boolean propagate) {
        this(true, propagate);
    }

    protected AbstractMidAgentCallback(boolean stack, boolean propagate) {
        super(stack);
        this.propagate = propagate;
    }

    protected AbstractMidAgentCallback(boolean stack, boolean propagate, String identifier) {
        super(stack, identifier);
        this.propagate = propagate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocation(String serviceProvider) {
        Map<String, String> map = this.locations;
        synchronized (map) {
            return this.locations.get(serviceProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocation(String serviceProvider, String location) {
        Map<String, String> map = this.locations;
        synchronized (map) {
            this.locations.put(serviceProvider, location);
        }
    }

    @Override
    public boolean propagate() {
        return this.propagate;
    }

    @Override
    public void doCallback(SnaMessage<?> message) throws MidCallbackException {
        int length;
        if (message == null) {
            return;
        }
        String path = message.getPath();
        if (path == null) {
            return;
        }
        int n = length = UNLISTENED == null ? 0 : UNLISTENED.length;
        for (int index = 0; index < length; ++index) {
            String unlistened = UNLISTENED[index];
            if (unlistened == null || !path.startsWith(unlistened)) continue;
            return;
        }
        try {
            switch (((SnaMessageSubType)((Object)message.getType())).getSnaMessageType()) {
                case ERROR: {
                    this.doHandle((SnaErrorMessageImpl)message);
                    break;
                }
                case LIFECYCLE: {
                    this.doHandle((SnaLifecycleMessageImpl)message);
                    break;
                }
                case RESPONSE: {
                    this.doHandle((SnaResponseMessage)message);
                    break;
                }
                case UPDATE: {
                    this.doHandle((SnaUpdateMessageImpl)message);
                    break;
                }
                case REMOTE: {
                    this.doHandle((SnaRemoteMessageImpl)message);
                    break;
                }
            }
        }
        catch (MidCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MidCallbackException(e);
        }
    }

    @Override
    public void doHandle(SnaLifecycleMessageImpl message) throws MidCallbackException {
    }

    @Override
    public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
    }

    @Override
    public void doHandle(SnaRemoteMessageImpl message) throws MidCallbackException {
    }

    @Override
    public void doHandle(SnaErrorMessageImpl message) throws MidCallbackException {
    }

    @Override
    public void doHandle(SnaResponseMessage<?, ?> message) throws MidCallbackException {
    }
}

