/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Fixed;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodDescription;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutorWrapper;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.Shortcut;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessMethod<T, R extends AccessMethodResponse<T>>
implements AccessMethod<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAccessMethod.class);
    protected final AccessMethodExecutor preProcessingExecutor;
    protected final AccessMethodExecutor postProcessingExecutor;
    protected final AccessMethod.Type type;
    protected final Map<Signature, Deque<AccessMethodExecutor>> map;
    protected final Map<Shortcut, Signature> shortcuts;
    protected final String uri;
    protected final Mediator mediator;
    private final ErrorHandler errorHandler;

    protected abstract <A extends AccessMethodResponseBuilder<T, R>> A createAccessMethodResponseBuilder(Object[] var1);

    protected AbstractAccessMethod(Mediator mediator, String uri, String type, AccessMethodExecutor preProcessingExecutor) {
        this(mediator, uri, type, preProcessingExecutor, null, null);
    }

    protected AbstractAccessMethod(Mediator mediator, String uri, String type, AccessMethodExecutor preProcessingExecutor, ErrorHandler errorHandler) {
        this(mediator, uri, type, preProcessingExecutor, null, errorHandler);
    }

    protected AbstractAccessMethod(Mediator mediator, String uri, String type, AccessMethodExecutor preProcessingExecutor, AccessMethodExecutor postProcessingExecutor, ErrorHandler errorHandler) {
        this.uri = uri;
        this.type = AccessMethod.Type.valueOf(type);
        this.mediator = mediator;
        this.map = new IdentityHashMap<Signature, Deque<AccessMethodExecutor>>();
        this.shortcuts = new IdentityHashMap<Shortcut, Signature>();
        this.preProcessingExecutor = preProcessingExecutor;
        this.postProcessingExecutor = postProcessingExecutor;
        this.errorHandler = errorHandler;
    }

    protected Signature getSignature(Class<?>[] parameterTypes) {
        Set<Signature> signatures = this.getSignatures();
        for (Signature signature : signatures) {
            if (!signature.equals(this.type.name(), parameterTypes == null ? new Class[]{} : parameterTypes)) continue;
            return signature;
        }
        return null;
    }

    private Signature createSignature(Class<?>[] parameterTypes) throws InvalidValueException {
        Class<?>[] types = parameterTypes == null ? new Class[]{} : parameterTypes;
        String[] names = new String[types.length];
        int length = types.length;
        for (int index = 0; index < length; ++index) {
            names[index] = "arg" + index;
        }
        return this.createSignature(types, names);
    }

    private Signature createSignature(Class<?>[] parameterTypes, String[] parameterNames) throws InvalidValueException {
        String[] names;
        Signature signature = null;
        Class<?>[] types = parameterTypes == null ? new Class[]{} : parameterTypes;
        String[] stringArray = names = parameterNames == null ? new String[]{} : parameterNames;
        if (types.length > names.length) {
            return signature;
        }
        Parameter[] parameters = new Parameter[types.length];
        int length = types.length;
        for (int index = 0; index < length; ++index) {
            try {
                parameters[index] = new Parameter(this.mediator, names[index], types[index]);
                continue;
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
        }
        signature = new Signature(this.mediator, this.type.name(), parameters);
        return signature;
    }

    public void addSignature(Class<?>[] parameterTypes, AccessMethodExecutor executor, AccessMethodExecutor.ExecutionPolicy policy) throws InvalidValueException {
        Signature signature = this.getSignature(parameterTypes);
        if (signature != null) {
            this.addSignature(signature, executor, policy);
            return;
        }
        this.addSignature(this.createSignature(parameterTypes), executor, policy);
    }

    public void addSignature(Class<?>[] parameterTypes, String[] parameterNames, AccessMethodExecutor executor, AccessMethodExecutor.ExecutionPolicy policy) throws InvalidValueException {
        Signature signature = this.getSignature(parameterTypes);
        if (signature != null) {
            this.addSignature(signature, executor, policy);
            return;
        }
        this.addSignature(this.createSignature(parameterTypes, parameterNames), executor, policy);
    }

    public void addSignature(Signature signature, AccessMethodExecutor executor, AccessMethodExecutor.ExecutionPolicy policy) {
        if (signature == null || signature.getName().intern() != this.type.name().intern()) {
            return;
        }
        Deque<AccessMethodExecutor> executors = this.map.get(signature);
        HashMap<Integer, Parameter> fixedParameters = new HashMap<Integer, Parameter>();
        if (executors == null) {
            Signature shortcut = signature;
            Signature reference = null;
            while ((reference = this.shortcuts.get(shortcut)) != null) {
                fixedParameters.putAll(((Shortcut)shortcut).getFixedParameters());
                shortcut = reference;
            }
            executors = this.map.get(shortcut);
            if (executors == null) {
                shortcut = this.getSignature(signature.getParameterTypes());
                if (shortcut != null) {
                    this.addSignature(shortcut, executor, policy);
                    return;
                }
                executors = new LinkedList<AccessMethodExecutor>();
                this.map.put(signature, executors);
            }
        }
        if (executor == null) {
            return;
        }
        AccessMethodExecutor.ExecutionPolicy executionPolicy = policy == null ? AccessMethodExecutor.ExecutionPolicy.AFTER : policy;
        AccessMethodExecutor methodExecutor = executor;
        if (fixedParameters != null && !fixedParameters.isEmpty()) {
            methodExecutor = new AccessMethodExecutorWrapper(executor);
            for (Map.Entry entry : fixedParameters.entrySet()) {
                Parameter parameter = (Parameter)entry.getValue();
                try {
                    ((AccessMethodExecutorWrapper)methodExecutor).put((Integer)entry.getKey(), new Fixed(parameter.getType(), parameter.getValue(), false));
                }
                catch (InvalidConstraintDefinitionException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    return;
                }
            }
        }
        switch (executionPolicy) {
            case AFTER: {
                executors.addLast(methodExecutor);
                break;
            }
            case BEFORE: {
                executors.addFirst(methodExecutor);
                break;
            }
            case REPLACE: {
                executors.clear();
                executors.addFirst(methodExecutor);
                break;
            }
        }
    }

    public void addShortcut(Shortcut shortcut, Signature signature) {
        if (shortcut == null || signature == null || this.map.get(signature) == null && this.shortcuts.get(signature) == null) {
            return;
        }
        this.shortcuts.put(shortcut, signature);
    }

    public AccessMethodDescription getDescription() {
        return new AccessMethodDescription(this);
    }

    public String getName() {
        return this.type.name();
    }

    public String getPath() {
        return this.uri;
    }

    @Override
    public int size() {
        return this.map.size() + this.shortcuts.size();
    }

    @Override
    public R invoke(Object[] parameters) {
        ArrayList signatures = new ArrayList();
        signatures.addAll(this.shortcuts.keySet().stream().sorted((s1, s2) -> s1.length() < s2.length() ? -1 : (s1.length() > s2.length() ? 1 : 0)).collect(Collectors.toList()));
        signatures.addAll(this.map.keySet().stream().sorted((s1, s2) -> s1.length() < s2.length() ? -1 : (s1.length() > s2.length() ? 1 : 0)).collect(Collectors.toList()));
        for (Signature signature : signatures) {
            if (!signature.validParameters(parameters)) continue;
            return this.invoke(signature);
        }
        return this.error(404, "Unknown signature");
    }

    public synchronized <A extends AccessMethodResponseBuilder<T, R>> R invoke(Signature signature) {
        if (signature == null) {
            return this.error(400, "Null signature");
        }
        Deque<AccessMethodExecutor> executors = null;
        Signature current = signature;
        Signature previous = null;
        while (true) {
            previous = current;
            if ((current = this.shortcuts.get(current)) == null) {
                executors = this.map.get(previous);
                break;
            }
            if (!Shortcut.class.isAssignableFrom(current.getClass())) {
                executors = this.map.get(current);
                break;
            }
            ((Shortcut)signature).push((Shortcut)current);
        }
        if (executors == null) {
            return this.error(404, "Unknown signature");
        }
        Object[] parameters = signature.values();
        A result = this.createAccessMethodResponseBuilder(parameters);
        if (this.preProcessingExecutor != null) {
            executors.addFirst(this.preProcessingExecutor);
        }
        if (this.postProcessingExecutor != null) {
            executors.addLast(this.postProcessingExecutor);
        }
        for (AccessMethodExecutor executor : executors) {
            if (executor == null) continue;
            try {
                executor.execute(result);
            }
            catch (Exception exception) {
                ((AccessMethodResponseBuilder)result).registerException(exception);
                if (!((AccessMethodResponseBuilder)result).exitOnError()) continue;
                break;
            }
        }
        if (this.preProcessingExecutor != null) {
            executors.removeFirst();
        }
        if (this.postProcessingExecutor != null) {
            executors.removeLast();
        }
        return ((AccessMethodResponseBuilder)result).createAccessMethodResponse();
    }

    private R error(int errorCode, String message) {
        return AccessMethodResponse.error(this.mediator, this.getPath(), this.getType(), errorCode, message, null);
    }

    @Override
    public Set<Signature> getSignatures() {
        HashSet<Signature> signatures = new HashSet<Signature>(this.map.keySet());
        signatures.addAll(this.shortcuts.keySet());
        return Collections.unmodifiableSet(signatures);
    }

    @Override
    public AccessMethod.Type getType() {
        return this.type;
    }

    public void stop() {
        this.map.clear();
        this.shortcuts.clear();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

