/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.sensinact.gateway.core.security.SecuredAccessException;
import org.eclipse.sensinact.gateway.core.security.UserUpdater;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserUpdater
implements UserUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserUpdater.class);
    private final String token;
    private final String updateType;
    private ServiceRegistration<?> registration;
    private Timer timer;

    protected abstract String doUpdate() throws SecuredAccessException;

    protected AbstractUserUpdater(String token, String updateType) {
        this.token = token;
        if (this.token == null) {
            throw new NullPointerException("Token required");
        }
        this.updateType = updateType;
        if (this.updateType == null) {
            throw new NullPointerException("Operation required");
        }
    }

    @Override
    public void setRegistration(ServiceRegistration<?> registration) {
        this.registration = registration;
        if (this.registration == null) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (AbstractUserUpdater.this.registration == null) {
                    return;
                }
                try {
                    AbstractUserUpdater.this.registration.unregister();
                }
                catch (IllegalStateException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }, 3600000L);
    }

    @Override
    public String validate(String token) throws SecuredAccessException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        builder.append(this.getUpdateType());
        builder.append("'");
        builder.append(" operation ");
        if (this.token.equals(token)) {
            String update = this.doUpdate();
            if (this.registration != null) {
                try {
                    this.registration.unregister();
                }
                catch (IllegalStateException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            builder.append("validated");
            builder.append("\n");
            builder.append(update);
            return builder.toString();
        }
        builder.append("not validated");
        return builder.toString();
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("Follow the link below to validate the '");
        builder.append(this.getUpdateType());
        builder.append("'");
        builder.append(" operation ");
        return builder.toString();
    }

    @Override
    public String getUpdateType() {
        return this.updateType;
    }
}

