/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.aries.rsa.discovery.endpoint.PropertiesMapper;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.xmlns.rsa.v1_0.EndpointDescriptionType;
import org.osgi.xmlns.rsa.v1_0.EndpointDescriptionsType;
import org.osgi.xmlns.rsa.v1_0.ObjectFactory;
import org.osgi.xmlns.rsa.v1_0.PropertyType;

public class EndpointDescriptionParser {
    private JAXBContext jaxbContext;

    public EndpointDescriptionParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EndpointDescriptionsType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<EndpointDescriptionType> readEpdts(InputStream is) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            StreamSource source = new StreamSource(is);
            JAXBElement jaxb = unmarshaller.unmarshal((Source)source, EndpointDescriptionsType.class);
            EndpointDescriptionsType decorations = (EndpointDescriptionsType)jaxb.getValue();
            return decorations.getEndpointDescription();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public List<EndpointDescription> readEndpoints(InputStream is) {
        List<EndpointDescriptionType> epdts = this.readEpdts(is);
        ArrayList<EndpointDescription> epds = new ArrayList<EndpointDescription>();
        for (EndpointDescriptionType epdt : epdts) {
            epds.add(this.convert(epdt));
        }
        return epds;
    }

    public EndpointDescription readEndpoint(InputStream is) {
        List<EndpointDescription> endpoints = this.readEndpoints(is);
        if (endpoints.isEmpty()) {
            return null;
        }
        return endpoints.iterator().next();
    }

    public void writeEndpoint(EndpointDescription epd, OutputStream os) {
        this.writeEpdt(this.convert(epd), os);
    }

    private void writeEpdt(EndpointDescriptionType endpointDescription, OutputStream os) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            EndpointDescriptionsType endpointDescriptions = new EndpointDescriptionsType();
            endpointDescriptions.getEndpointDescription().add(endpointDescription);
            JAXBElement<EndpointDescriptionsType> el = new ObjectFactory().createEndpointDescriptions(endpointDescriptions);
            marshaller.marshal(el, os);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            this.safeClose(os);
        }
    }

    private void safeClose(OutputStream os) {
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private EndpointDescriptionType convert(EndpointDescription epd) {
        List<PropertyType> props = new PropertiesMapper().fromProps(epd.getProperties());
        EndpointDescriptionType epdt = new EndpointDescriptionType();
        epdt.getProperty().addAll(props);
        return epdt;
    }

    private EndpointDescription convert(EndpointDescriptionType epdt) {
        Map<String, Object> props = new PropertiesMapper().toProps(epdt.getProperty());
        return new EndpointDescription(props);
    }
}

