/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal;

import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPDiscoveryListenerItf;
import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPDiscoveryNotifierItf;
import org.eclipse.sensinact.gateway.protocol.ssdp.api.SSDPEvent;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.SSDPDescriptionPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiRequestPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodiDevicesDiscovery
implements SSDPDiscoveryListenerItf {
    private static final Logger LOG = LoggerFactory.getLogger(KodiDevicesDiscovery.class);
    private Mediator mediator;
    private SimpleHttpProtocolStackEndpoint connector;

    public KodiDevicesDiscovery(Mediator mediator, SimpleHttpProtocolStackEndpoint connector, String kodiPattern) {
        this.mediator = mediator;
        this.connector = connector;
        mediator.attachOnServiceAppearing(SSDPDiscoveryNotifierItf.class, null, (Executable)new Executable<SSDPDiscoveryNotifierItf, Void>(){

            public Void execute(SSDPDiscoveryNotifierItf notifier) throws Exception {
                String kodiPattern = (String)KodiDevicesDiscovery.this.mediator.getProperty("kodi.regex");
                notifier.addListener((SSDPDiscoveryListenerItf)KodiDevicesDiscovery.this, kodiPattern);
                List descriptionPackets = notifier.getDescriptions(kodiPattern);
                for (SSDPDescriptionPacket descriptionPacket : descriptionPackets) {
                    KodiDevicesDiscovery.this.eventSSDP(SSDPEvent.DISCOVER, descriptionPacket);
                }
                return null;
            }
        });
    }

    public void eventSSDP(SSDPEvent ssdpEvent, SSDPDescriptionPacket packet) {
        LOG.debug("New SSDP event (" + ssdpEvent + "): " + packet.toString());
        String serviceProvider = packet.getFriendlyName().replace("(", "").replace(")", "");
        String url = "http://" + packet.getUrl() + "/jsonrpc";
        try {
            this.connector.process((Packet)new KodiRequestPacket(serviceProvider, "admin", "jsonurl", url));
        }
        catch (InvalidPacketException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

