/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.AbstractRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.RequestWrapper;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class HttpRequestWrapper
extends HttpServletRequestWrapper
implements RequestWrapper {
    private Map<String, List<String>> queryMap;
    private String content;

    public HttpRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    @Override
    public Map<String, List<String>> getQueryMap() {
        if (this.queryMap == null) {
            try {
                this.queryMap = AbstractRequestWrapper.processRequestQuery(super.getQueryString());
            }
            catch (UnsupportedEncodingException e) {
                this.queryMap = Collections.emptyMap();
            }
        }
        return this.queryMap;
    }

    @Override
    public String getContent() {
        if (this.content == null) {
            try {
                ServletInputStream input = super.getInputStream();
                byte[] stream = IOUtils.read((InputStream)input, (int)super.getContentLength(), (boolean)true);
                this.content = new String(stream);
            }
            catch (IOException e) {
                AbstractRequestWrapper.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.content;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Enumeration en = super.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            ArrayList value = Collections.list(super.getHeaders(name));
            map.put(name, value);
        }
        return map;
    }
}

