/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import org.eclipse.sensinact.gateway.generic.packet.PayloadResourceFragment;
import org.eclipse.sensinact.gateway.generic.packet.TaskIdValuePair;

public class PayloadResourceFragmentImpl
implements PayloadResourceFragment {
    private String taskIdentifier;
    protected final String attributeId;
    protected final String metadataId;
    protected final Object data;
    protected long timestamp;

    public PayloadResourceFragmentImpl(Object data) {
        this(null, null, data);
    }

    public PayloadResourceFragmentImpl(String attributeId, String metadataId, Object data) {
        this.attributeId = attributeId;
        this.metadataId = metadataId;
        this.data = data;
        this.timestamp = -1L;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public String getMetadataId() {
        return this.metadataId;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public TaskIdValuePair AsTaskIdValuePair(String taskIdentifier) {
        if (taskIdentifier == null) {
            return null;
        }
        this.taskIdentifier = taskIdentifier;
        if (this.attributeId != null) {
            this.taskIdentifier = taskIdentifier + '#' + this.attributeId;
            if (this.metadataId != null) {
                this.taskIdentifier = this.taskIdentifier + '#' + this.metadataId;
            }
        }
        return new TaskIdValuePair(this.taskIdentifier, this.data, this.getTimestamp());
    }

    public long setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this.timestamp;
    }

    public long getTimestamp() {
        if (this.timestamp == -1L) {
            return System.currentTimeMillis();
        }
        return this.timestamp;
    }

    @Override
    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public String getName() {
        return this.taskIdentifier;
    }
}

