/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import java.util.Collection;
import org.eclipse.sensinact.gateway.app.api.exception.ResourceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.watchdog.AppResourceLifecycleWatchDog;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;

class AppWatchdogExecutor
implements AccessMethodExecutor {
    private final ApplicationService service;
    private final AppResourceLifecycleWatchDog resourceWatchDog;

    AppWatchdogExecutor(AppServiceMediator mediator, ApplicationService service, Collection<String> resources) {
        this.service = service;
        this.resourceWatchDog = new AppResourceLifecycleWatchDog(mediator, service, resources);
    }

    public Void execute(AccessMethodResponseBuilder snaResult) throws Exception {
        SnaErrorMessage message;
        String uri = snaResult.getPath();
        ApplicationStatus status = this.getApplicationState(this.service.getResource("status"));
        if (uri.endsWith("START")) {
            SnaErrorMessage message2;
            if (!snaResult.hasError() && ApplicationStatus.INSTALLED.equals((Object)status) && (message2 = this.resourceWatchDog.start(this.service.getApplication().getSession())) != null) {
                snaResult.registerException((Exception)new ResourceNotFoundException("Unable to start the application: " + message2.getJSON()));
            }
        } else if (uri.endsWith("STOP") && ApplicationStatus.ACTIVE.equals((Object)status) && (message = this.resourceWatchDog.stop(this.service.getApplication().getSession())) != null) {
            snaResult.registerException((Exception)new ResourceNotFoundException("Unable to stop the application: " + message.getJSON()));
        }
        return null;
    }

    private ApplicationStatus getApplicationState(ResourceImpl state) {
        Attribute stateAttribute;
        if (state != null && (stateAttribute = state.getAttribute("value")) != null) {
            return (ApplicationStatus)((Object)stateAttribute.getValue());
        }
        return null;
    }
}

