/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.smpl;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.ChainedHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.ChainedHttpTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentChainedHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.SimpleHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextHandler;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextHandler;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.ChainedHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RecurrentChainedHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RecurrentHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.SimpleHttpTaskDescription;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.osgi.framework.BundleContext;

public abstract class HttpActivator
extends AbstractActivator<HttpMediator> {
    protected SimpleHttpProtocolStackEndpoint endpoint;

    public void doStart() throws Exception {
        ((HttpMediator)this.mediator).setTaskProcessingContextHandler(this.getProcessingContextHandler());
        ((HttpMediator)this.mediator).setTaskProcessingContextFactory(this.getTaskProcessingContextFactory());
        ((HttpMediator)this.mediator).setChainedTaskProcessingContextFactory(this.getChainedTaskProcessingContextFactory());
        ExtModelConfiguration configuration = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, this.getPacketType()).withStartAtInitializationTime(this.isStartingAtInitializationTime()).withServiceBuildPolicy(this.getServiceBuildPolicy()).withResourceBuildPolicy(this.getResourceBuildPolicy()).build(new Object[]{this.getResourceDescriptionFile(), this.getDefaults()});
        this.endpoint = this.configureProtocolStackEndpoint();
        this.connect(configuration);
    }

    protected void connect(ExtModelConfiguration configuration) throws InvalidProtocolStackException {
        this.endpoint.connect(configuration);
    }

    public void doStop() throws Exception {
        this.endpoint.stop();
    }

    protected Map<String, String> getDefaults() {
        return Collections.emptyMap();
    }

    protected boolean isStartingAtInitializationTime() {
        return true;
    }

    protected byte getResourceBuildPolicy() {
        return SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy();
    }

    protected byte getServiceBuildPolicy() {
        return (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_APPEARING_ON_DESCRIPTION.getPolicy());
    }

    protected Class<? extends HttpPacket> getPacketType() {
        return HttpPacket.class;
    }

    protected Class<? extends SimpleHttpProtocolStackEndpoint> getEndpointType() {
        return SimpleHttpProtocolStackEndpoint.class;
    }

    protected HttpTaskProcessingContextHandler getProcessingContextHandler() {
        return new DefaultHttpTaskProcessingContextHandler();
    }

    public HttpTaskProcessingContextFactory getTaskProcessingContextFactory() {
        return new DefaultHttpTaskProcessingContextFactory(this.mediator);
    }

    public HttpChainedTaskProcessingContextFactory getChainedTaskProcessingContextFactory() {
        return new DefaultHttpChainedTaskProcessingContextFactory(this.mediator);
    }

    protected String getResourceDescriptionFile() {
        return "resources.xml";
    }

    public HttpMediator doInstantiate(BundleContext context) {
        return new HttpMediator(context);
    }

    public SimpleHttpProtocolStackEndpoint configureProtocolStackEndpoint() throws Exception {
        int index;
        int length;
        SimpleHttpProtocolStackEndpoint endpoint = (SimpleHttpProtocolStackEndpoint)((Object)ReflectUtils.getInstance(this.getEndpointType(), (Object[])new Object[]{this.mediator}));
        HttpTasks taskArray = ((Object)((Object)this)).getClass().getAnnotation(HttpTasks.class);
        SimpleHttpTask[] tasks = taskArray == null ? null : taskArray.tasks();
        int n = length = tasks == null ? 0 : tasks.length;
        for (index = 0; index < length; ++index) {
            endpoint.registerAdapter(SimpleHttpTaskDescription.toDescription(tasks[index]));
        }
        RecurrentHttpTask[] recurrences = taskArray == null ? null : taskArray.recurrences();
        int n2 = length = recurrences == null ? 0 : recurrences.length;
        for (index = 0; index < length; ++index) {
            endpoint.registerAdapter(RecurrentHttpTaskDescription.toDescription(recurrences[index]));
        }
        ChainedHttpTasks chainedTaskArray = ((Object)((Object)this)).getClass().getAnnotation(ChainedHttpTasks.class);
        ChainedHttpTask[] chainedTasks = chainedTaskArray == null ? null : chainedTaskArray.tasks();
        int n3 = length = chainedTasks == null ? 0 : chainedTasks.length;
        for (index = 0; index < length; ++index) {
            endpoint.registerAdapter(ChainedHttpTaskDescription.toDescription(chainedTasks[index]));
        }
        RecurrentChainedHttpTask[] recurrentChainedTasks = chainedTaskArray == null ? null : chainedTaskArray.recurrences();
        int n4 = length = recurrentChainedTasks == null ? 0 : recurrentChainedTasks.length;
        for (index = 0; index < length; ++index) {
            endpoint.registerAdapter(RecurrentChainedHttpTaskDescription.toDescription(recurrentChainedTasks[index]));
        }
        return endpoint;
    }
}

