/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.aries.rsa.core.ImportRegistrationImpl;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.apache.aries.rsa.spi.IntentUnsatisfiedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServiceFactory
implements ServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClientServiceFactory.class);
    private EndpointDescription endpoint;
    private DistributionProvider handler;
    private ImportRegistrationImpl importRegistration;
    private boolean closeable;
    private int serviceCounter;

    public ClientServiceFactory(EndpointDescription endpoint, DistributionProvider handler, ImportRegistrationImpl ir) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.importRegistration = ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle requestingBundle, ServiceRegistration sreg) {
        List<String> interfaceNames = this.endpoint.getInterfaces();
        final BundleContext consumerContext = requestingBundle.getBundleContext();
        final ClassLoader consumerLoader = ((BundleWiring)requestingBundle.adapt(BundleWiring.class)).getClassLoader();
        try {
            LOG.debug("getService() from serviceFactory for {}", interfaceNames);
            final ArrayList interfaces = new ArrayList();
            for (String ifaceName : interfaceNames) {
                interfaces.add(consumerLoader.loadClass(ifaceName));
            }
            Object proxy = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Class[] ifAr = interfaces.toArray(new Class[0]);
                    return ClientServiceFactory.this.handler.importEndpoint(consumerLoader, consumerContext, ifAr, ClientServiceFactory.this.endpoint);
                }
            });
            ClientServiceFactory clientServiceFactory = this;
            synchronized (clientServiceFactory) {
                ++this.serviceCounter;
            }
            return proxy;
        }
        catch (IntentUnsatisfiedException iue) {
            LOG.info("Did not create proxy for {} because intent {} could not be satisfied", interfaceNames, (Object)iue.getIntent());
        }
        catch (Exception e) {
            LOG.warn("Problem creating a remote proxy for {}", interfaceNames, (Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle requestingBundle, ServiceRegistration sreg, Object serviceObject) {
        ClientServiceFactory clientServiceFactory = this;
        synchronized (clientServiceFactory) {
            --this.serviceCounter;
            LOG.debug("Services still provided by this ServiceFactory: {}", (Object)this.serviceCounter);
            this.closeIfUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseable(boolean closeable) {
        ClientServiceFactory clientServiceFactory = this;
        synchronized (clientServiceFactory) {
            this.closeable = closeable;
            this.closeIfUnused();
        }
    }

    private synchronized void closeIfUnused() {
        if (this.serviceCounter <= 0 && this.closeable) {
            this.importRegistration.closeAll();
        }
    }
}

