/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core.event;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class EventAdminSender {
    private HashMap<Integer, String> typeToTopic;
    private BundleContext context;

    public EventAdminSender(BundleContext context) {
        this.context = context;
        this.typeToTopic = new HashMap();
        this.typeToTopic.put(6, "EXPORT_ERROR");
        this.typeToTopic.put(2, "EXPORT_REGISTRATION");
        this.typeToTopic.put(3, "EXPORT_UNREGISTRATION");
        this.typeToTopic.put(10, "EXPORT_UPDATE");
        this.typeToTopic.put(7, "EXPORT_WARNING");
        this.typeToTopic.put(5, "IMPORT_ERROR");
        this.typeToTopic.put(1, "IMPORT_REGISTRATION");
        this.typeToTopic.put(4, "IMPORT_UNREGISTRATION");
        this.typeToTopic.put(9, "IMPORT_UPDATE");
        this.typeToTopic.put(8, "IMPORT_WARNING");
    }

    public void send(RemoteServiceAdminEvent rsaEvent) {
        final Event event = this.toEvent(rsaEvent);
        ServiceReference sref = this.context.getServiceReference(EventAdmin.class);
        if (sref != null) {
            final EventAdmin eventAdmin = (EventAdmin)this.context.getService(sref);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    eventAdmin.postEvent(event);
                    return null;
                }
            });
            this.context.ungetService(sref);
        }
    }

    private Event toEvent(RemoteServiceAdminEvent rsaEvent) {
        ImportReference importReference;
        String topic = this.getTopic(rsaEvent);
        HashMap<String, Object> props = new HashMap<String, Object>();
        Bundle bundle = rsaEvent.getSource();
        props.put("bundle", bundle);
        props.put("bundle.id", bundle.getBundleId());
        props.put("bundle.symbolicname", bundle.getSymbolicName());
        props.put("bundle.version", bundle.getVersion());
        props.put("bundle.signer", "");
        Throwable exception = rsaEvent.getException();
        if (exception != null) {
            props.put("exception", exception);
            props.put("exception.class", exception.getClass().getName());
            props.put("exception.message", exception.getMessage());
        }
        if (rsaEvent.getExportReference() != null) {
            EndpointDescription endpoint = rsaEvent.getExportReference().getExportedEndpoint();
            props.put("endpoint.framework.uuid", endpoint.getFrameworkUUID());
            props.put("endpoint.id", endpoint.getId());
            props.put("objectClass", endpoint.getInterfaces());
        }
        if ((importReference = rsaEvent.getImportReference()) != null && importReference.getImportedEndpoint() != null) {
            props.put("service.imported.configs", importReference.getImportedEndpoint().getConfigurationTypes());
        }
        props.put("timestamp", System.currentTimeMillis());
        props.put("event", rsaEvent);
        return new Event(topic, props);
    }

    private String getTopic(RemoteServiceAdminEvent rsaEvent) {
        return "org/osgi/service/remoteserviceadmin/" + this.typeToTopic.get(rsaEvent.getType());
    }
}

