/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.slider.internal;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.sensinact.gateway.simulated.slider.api.SliderSetterItf;
import org.eclipse.sensinact.gateway.simulated.slider.internal.SliderAdapter;

public class SliderGUI
extends JFrame
implements MouseListener,
SliderSetterItf {
    private final SliderAdapter listener;
    Long lastValueTimeStamp = 0L;

    public SliderGUI(SliderAdapter listener) {
        this.listener = listener;
        super.setDefaultCloseOperation(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SliderGUI.this.createAndShowGUI();
            }
        });
    }

    @Override
    public void stop() {
        super.setVisible(false);
        super.dispose();
    }

    private void createAndShowGUI() {
        super.setTitle("slider");
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 3));
        JSlider slider = new JSlider(0, 0, 1000, 0);
        slider.addMouseListener(this);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Long currentValueTimeStamp = Calendar.getInstance().getTime().getTime();
                if (currentValueTimeStamp - SliderGUI.this.lastValueTimeStamp > 500L) {
                    SliderGUI.this.lastValueTimeStamp = currentValueTimeStamp;
                    JSlider slider = (JSlider)e.getSource();
                    SliderGUI.this.listener.mouseReleased(slider.getValue());
                }
            }
        });
        slider.setMajorTickSpacing(100);
        slider.setMinorTickSpacing(25);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        Font font = new Font("SansSerif", 0, 10);
        slider.setFont(font);
        sliderPanel.add(slider);
        sliderPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        super.add((Component)sliderPanel, "Center");
        super.setSize(550, 100);
        super.setVisible(true);
    }

    @Override
    public void move(int i) {
        this.listener.mouseReleased(i);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.move(((JSlider)event.getSource()).getValue());
    }
}

