/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.button.osgi;

import java.awt.Component;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.simulated.button.api.ButtonSetterItf;
import org.eclipse.sensinact.gateway.simulated.button.internal.ButtonAdapter;
import org.eclipse.sensinact.gateway.simulated.button.internal.ButtonGUI;
import org.eclipse.sensinact.gateway.simulated.button.internal.ButtonPacket;
import org.eclipse.sensinact.gateway.simulated.button.internal.ButtonSetter;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    private LocalProtocolStackEndpoint<ButtonPacket> connector;
    private ExtModelConfiguration<ButtonPacket> manager;
    private ButtonSetterItf buttonPanel;
    private JFrame jFrame;
    private ServiceRegistration<ButtonSetterItf> buttonRegistration;

    public void doStart() throws Exception {
        if (this.manager == null) {
            this.manager = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, ButtonPacket.class).withStartAtInitializationTime(true).build(new Object[]{"button-resource.xml", Collections.emptyMap()});
        }
        if (this.connector == null) {
            this.connector = new LocalProtocolStackEndpoint(this.mediator);
        }
        this.connector.connect(this.manager);
        if ("true".equals(this.mediator.getProperty(GUI_ENABLED))) {
            this.buttonPanel = new ButtonGUI(this.mediator, new ButtonAdapter(this.connector));
            this.jFrame = new JFrame();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Activator.this.createAndShowGUI((JLabel)((Object)Activator.this.buttonPanel));
                }
            });
        } else {
            this.buttonPanel = new ButtonSetter(new ButtonAdapter(this.connector));
            this.buttonRegistration = this.mediator.getContext().registerService(ButtonSetterItf.class, (Object)this.buttonPanel, null);
        }
    }

    public void doStop() throws Exception {
        this.connector.stop();
        this.buttonPanel.stop();
        if (this.jFrame != null) {
            this.jFrame.dispose();
        }
        if (this.buttonRegistration != null) {
            this.buttonRegistration.unregister();
        }
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }

    private void createAndShowGUI(JLabel gui) {
        this.jFrame.add((Component)gui, "Center");
        this.jFrame.setSize(136, 156);
        this.jFrame.setTitle("button");
        this.jFrame.setVisible(true);
    }
}

