/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.test;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.sensinact.gateway.sthbnd.http.test.doGet;
import org.eclipse.sensinact.gateway.sthbnd.http.test.doPost;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class JettyTestServer
implements Runnable {
    private Server server;
    private Map<Class<? extends Annotation>, List<Callback>> callbacks = new HashMap<Class<? extends Annotation>, List<Callback>>();
    private boolean running = false;

    public JettyTestServer(int port) throws Exception {
        this.server = new Server(port);
        ServletHandler handler = new ServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)new JettyTestServerCallbackServlet());
        holder.setName("callbackServlet");
        handler.addServletWithMapping(holder, "/");
        this.server.setHandler((Handler)handler);
    }

    public void registerCallback(Object callback) {
        Map postMethods;
        Map getMethods = ReflectUtils.getAnnotatedMethods(callback.getClass(), doGet.class);
        if (getMethods != null && getMethods.size() > 0) {
            List<Callback> callbackList = this.callbacks.get(doGet.class);
            if (callbackList == null) {
                callbackList = new ArrayList<Callback>();
                this.callbacks.put(doGet.class, callbackList);
            }
            Iterator iterator = getMethods.keySet().iterator();
            while (iterator.hasNext()) {
                callbackList.add(new Callback(callback, (Method)iterator.next()));
            }
        }
        if ((postMethods = ReflectUtils.getAnnotatedMethods(callback.getClass(), doPost.class)) != null && postMethods.size() > 0) {
            List<Callback> callbackList = this.callbacks.get(doPost.class);
            if (callbackList == null) {
                callbackList = new ArrayList<Callback>();
                this.callbacks.put(doPost.class, callbackList);
            }
            Iterator iterator = postMethods.keySet().iterator();
            while (iterator.hasNext()) {
                callbackList.add(new Callback(callback, (Method)iterator.next()));
            }
        }
    }

    public boolean isStarted() {
        return this.running;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void join() throws Exception {
        this.server.join();
        Thread.sleep(2000L);
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }

    public class JettyTestServerCallbackServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (!response.isCommitted()) {
                final AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        JettyTestServerCallbackServlet.this.doHandle(context, (List)JettyTestServer.this.callbacks.get(doGet.class));
                    }

                    public void onError(Throwable t) {
                        t.printStackTrace();
                    }
                });
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (!response.isCommitted()) {
                final AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        JettyTestServerCallbackServlet.this.doHandle(context, (List)JettyTestServer.this.callbacks.get(doPost.class));
                    }

                    public void onError(Throwable t) {
                        t.printStackTrace();
                    }
                });
            }
        }

        private final void doHandle(AsyncContext context, List<Callback> callbackList) {
            int length = callbackList == null ? 0 : callbackList.size();
            HttpServletRequest request = (HttpServletRequest)context.getRequest();
            HttpServletResponse response = (HttpServletResponse)context.getResponse();
            for (int index = 0; index < length; ++index) {
                Callback callback = callbackList.get(index);
                Class<?>[] parameterTypes = callback.method.getParameterTypes();
                int parametersLength = parameterTypes == null ? 0 : parameterTypes.length;
                Object[] parameters = new Object[parametersLength];
                for (int parametersIndex = 0; parametersIndex < parametersLength; ++parametersIndex) {
                    Class<?> parameterClass = parameterTypes[parametersIndex];
                    parameters[parametersIndex] = ServletRequest.class.isAssignableFrom(parameterClass) ? request : (ServletResponse.class.isAssignableFrom(parameterClass) ? response : (ServletContext.class.isAssignableFrom(parameterClass) ? super.getServletContext() : (ServletConfig.class.isAssignableFrom(parameterClass) ? super.getServletConfig() : super.getServletContext().getAttribute(parameterClass.getCanonicalName()))));
                }
                try {
                    callback.invoke(parameters);
                    continue;
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            }
            context.complete();
        }
    }

    public class Callback {
        public final Object target;
        public final Method method;

        Callback(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public Object invoke(Object[] parameters) throws Exception {
            this.method.setAccessible(true);
            return this.method.invoke(this.target, parameters);
        }
    }
}

