/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command.impl;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.impl.GatewayThreadImpl;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.metrics.IMetricCounter;
import org.eclipse.sensinact.core.metrics.IMetricTimer;
import org.eclipse.sensinact.core.metrics.IMetricsHistogram;
import org.eclipse.sensinact.core.metrics.IMetricsManager;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.ModelBuilder;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ServiceBuilder;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.service.typedevent.TypedEventBus;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@ExtendWith(value={MockitoExtension.class})
public class GatewayThreadImplTest {
    @Mock
    TypedEventBus typedEventBus;
    @Spy
    ProviderPackage providerPackage = ProviderPackage.eINSTANCE;
    @Spy
    ResourceSet resourceSet = EMFTestUtil.createResourceSet();
    GatewayThreadImpl thread = null;

    @BeforeEach
    void setup() throws IOException {
        Path path = Paths.get("data", "instances");
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walk(path, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(t -> {
                try {
                    Files.delete(t);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        this.resourceSet = EMFTestUtil.createResourceSet();
        IMetricsManager metrics = (IMetricsManager)Mockito.mock(IMetricsManager.class);
        IMetricCounter counter = (IMetricCounter)Mockito.mock(IMetricCounter.class);
        IMetricsHistogram histogram = (IMetricsHistogram)Mockito.mock(IMetricsHistogram.class);
        IMetricTimer timer = (IMetricTimer)Mockito.mock(IMetricTimer.class);
        Mockito.lenient().when((Object)metrics.getCounter(ArgumentMatchers.anyString())).thenReturn((Object)counter);
        Mockito.lenient().when((Object)metrics.getHistogram(ArgumentMatchers.anyString())).thenReturn((Object)histogram);
        Mockito.lenient().when((Object)metrics.withTimer(ArgumentMatchers.anyString())).thenReturn((Object)timer);
        Mockito.lenient().when((Object)metrics.withTimers((String[])ArgumentMatchers.any())).thenReturn((Object)timer);
        this.thread = new GatewayThreadImpl(metrics, this.typedEventBus, this.resourceSet, this.providerPackage);
    }

    @AfterEach
    void teardown() throws IOException {
        this.thread.deactivate();
        Path path = Paths.get("data", new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walk(path, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(t -> {
                try {
                    Files.delete(t);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @Test
    void testExecute() throws Exception {
        int delay = 100;
        int testValue = 5;
        int threadWaitTime = 200;
        Semaphore sem = new Semaphore(0);
        AbstractTwinCommand<Integer> command = new AbstractTwinCommand<Integer>(){

            protected Promise<Integer> call(SensinactDigitalTwin model, PromiseFactory promiseFactory) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return promiseFactory.resolved((Object)5);
            }
        };
        Promise result = this.thread.execute((AbstractSensinactCommand)command).onResolve(sem::release);
        Assertions.assertFalse((boolean)result.isDone());
        Assertions.assertTrue((boolean)sem.tryAcquire(300L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((int)5, (Integer)((Integer)result.getValue()));
    }

    @Nested
    class LifecycleTests {
        LifecycleTests() {
        }

        @Nested
        class ModelLifecycleTests {
            ModelLifecycleTests() {
            }

            @Test
            void testModelClosed() throws Exception {
                Model m = (Model)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Model>(){

                    protected Promise<Model> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        Model mo = ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("providerModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        return promiseFactory.resolved((Object)mo);
                    }
                }).getValue();
                Assertions.assertFalse((boolean)m.isValid());
            }

            @Test
            void testServiceClosed() throws Exception {
                Service s = (Service)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Service>(){

                    protected Promise<Service> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("serviceModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        return promiseFactory.resolved((Object)((Service)modelMgr.getModel("serviceModel").getServices().get("bar")));
                    }
                }).getValue();
                Assertions.assertFalse((boolean)s.isValid());
            }

            @Test
            void testResourceClosed() throws Exception {
                Resource r = (Resource)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Resource>(){

                    protected Promise<Resource> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("resourceModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        return promiseFactory.resolved((Object)((Resource)((Service)modelMgr.getModel("resourceModel").getServices().get("bar")).getResources().get("foobar")));
                    }
                }).getValue();
                Assertions.assertFalse((boolean)r.isValid());
            }
        }

        @Nested
        class TwinLifecycleTests {
            TwinLifecycleTests() {
            }

            @Test
            void testSensinactProviderClosed() throws Exception {
                SensinactProvider sp = (SensinactProvider)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<SensinactProvider>(){

                    protected Promise<SensinactProvider> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("providerModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        twin.createProvider("providerModel", "providerFoo");
                        return promiseFactory.resolved((Object)twin.getProvider("providerFoo"));
                    }
                }).getValue();
                Assertions.assertFalse((boolean)sp.isValid());
            }

            @Test
            void testSensinactServiceClosed() throws Exception {
                SensinactService ss = (SensinactService)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<SensinactService>(){

                    protected Promise<SensinactService> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("serviceModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        twin.createProvider("serviceModel", "serviceFoo");
                        return promiseFactory.resolved((Object)twin.getService("serviceFoo", "bar"));
                    }
                }).getValue();
                Assertions.assertFalse((boolean)ss.isValid());
            }

            @Test
            void testSensinactResourceClosed() throws Exception {
                SensinactResource sr = (SensinactResource)GatewayThreadImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<SensinactResource>(){

                    protected Promise<SensinactResource> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                        ((ModelBuilder)((ServiceBuilder)modelMgr.createModel("resourceModel").withService("bar").withResource("foobar").withType(Integer.class).withInitialValue((Object)42).build()).build()).build();
                        twin.createProvider("resourceModel", "resourceFoo");
                        return promiseFactory.resolved((Object)twin.getResource("resourceFoo", "bar", "foobar"));
                    }
                }).getValue();
                Assertions.assertFalse((boolean)sr.isValid());
            }
        }
    }
}

