/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command.impl;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.verb.ACT;
import org.eclipse.sensinact.core.annotation.verb.ActParam;
import org.eclipse.sensinact.core.annotation.verb.GET;
import org.eclipse.sensinact.core.annotation.verb.GetParam;
import org.eclipse.sensinact.core.annotation.verb.SET;
import org.eclipse.sensinact.core.annotation.verb.SetParam;
import org.eclipse.sensinact.core.annotation.verb.UriParam;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GetLevel;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.command.impl.GatewayThreadImpl;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.metrics.IMetricCounter;
import org.eclipse.sensinact.core.metrics.IMetricTimer;
import org.eclipse.sensinact.core.metrics.IMetricsHistogram;
import org.eclipse.sensinact.core.metrics.IMetricsManager;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceBuilder;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.core.whiteboard.AbstractDescriptiveAct;
import org.eclipse.sensinact.core.whiteboard.AbstractDescriptiveReadOnly;
import org.eclipse.sensinact.core.whiteboard.AbstractDescriptiveReadWrite;
import org.eclipse.sensinact.core.whiteboard.WhiteboardAct;
import org.eclipse.sensinact.core.whiteboard.WhiteboardGet;
import org.eclipse.sensinact.core.whiteboard.WhiteboardHandler;
import org.eclipse.sensinact.core.whiteboard.WhiteboardSet;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.service.typedevent.TypedEventBus;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@ExtendWith(value={MockitoExtension.class})
public class WhiteboardImplTest {
    private static final String PROVIDER_A = "providerA";
    private static final String PROVIDER_B = "providerB";
    GatewayThreadImpl thread;
    @Mock
    TypedEventBus typedEventBus;
    private ResourceSet resourceSet;

    @BeforeEach
    void start() throws NoSuchMethodException, SecurityException {
        this.resourceSet = EMFTestUtil.createResourceSet();
        IMetricsManager metrics = (IMetricsManager)Mockito.mock(IMetricsManager.class);
        IMetricCounter counter = (IMetricCounter)Mockito.mock(IMetricCounter.class);
        IMetricsHistogram histogram = (IMetricsHistogram)Mockito.mock(IMetricsHistogram.class);
        IMetricTimer timer = (IMetricTimer)Mockito.mock(IMetricTimer.class);
        Mockito.lenient().when((Object)metrics.getCounter(ArgumentMatchers.anyString())).thenReturn((Object)counter);
        Mockito.lenient().when((Object)metrics.getHistogram(ArgumentMatchers.anyString())).thenReturn((Object)histogram);
        Mockito.lenient().when((Object)metrics.withTimer(ArgumentMatchers.anyString())).thenReturn((Object)timer);
        Mockito.lenient().when((Object)metrics.withTimers((String[])ArgumentMatchers.any(String[].class))).thenReturn((Object)timer);
        this.thread = new GatewayThreadImpl(metrics, this.typedEventBus, this.resourceSet, ProviderPackage.eINSTANCE);
    }

    void createProviders(final String modelName, final String serviceName) throws Throwable {
        this.thread.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                SensinactProvider providerA = twin.createProvider(modelName, WhiteboardImplTest.PROVIDER_A);
                twin.createProvider(modelName, WhiteboardImplTest.PROVIDER_B);
                SensinactService service = (SensinactService)providerA.getServices().get(serviceName);
                Assertions.assertNotNull((Object)service);
                return pf.resolved(null);
            }
        }).getValue();
    }

    void runRcCommand(String provider, String service, String resource, final Function<SensinactResource, Void> call) throws Throwable {
        try {
            this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>(provider, service, resource){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    call.apply(resource);
                    return pf.resolved(null);
                }
            }).getValue();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    <T> TimedValue<T> getValue(String provider, String service, String resource, final Class<T> type) throws Throwable {
        try {
            return (TimedValue)this.thread.execute((AbstractSensinactCommand)new ResourceCommand<TimedValue<T>>(provider, service, resource){

                protected Promise<TimedValue<T>> call(SensinactResource resource, PromiseFactory pf) {
                    return resource.getValue(type);
                }
            }).getValue();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    <T> TimedValue<T> getValue(String provider, String service, String resource, final Class<T> type, final GetLevel getLevel) throws Throwable {
        try {
            return (TimedValue)this.thread.execute((AbstractSensinactCommand)new ResourceCommand<TimedValue<T>>(provider, service, resource){

                protected Promise<TimedValue<T>> call(SensinactResource resource, PromiseFactory pf) {
                    return resource.getValue(type, getLevel);
                }
            }).getValue();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    Object setValue(String provider, String svc, String rc, final Function<SensinactResource, Promise<?>> setter) throws Throwable {
        try {
            return this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Object>(provider, svc, rc){

                protected Promise<Object> call(SensinactResource resource, PromiseFactory pf) {
                    return pf.resolvedWith((Promise)setter.apply(resource));
                }
            }).getValue();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    Object act(String provider, String service, String resource, final Map<String, Object> params) throws Throwable {
        try {
            return this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Object>(provider, service, resource){

                protected Promise<Object> call(SensinactResource resource, PromiseFactory pf) {
                    return resource.act(params);
                }
            }).getValue();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Nested
    class HandlerSelectionTest {
        HandlerSelectionTest() {
        }

        Map<String, Object> makeProps(long svcId, String model, String service, String resource, String ... providers) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("service.id", svcId);
            props.put("sensiNact.whiteboard.model", model);
            props.put("sensiNact.whiteboard.service", service);
            props.put("sensiNact.whiteboard.resource", resource);
            props.put("sensiNact.provider.name", providers.length == 0 ? null : providers);
            return props;
        }

        void makeResource(final String modelName, final String serviceName, final String resourceName, final Consumer<ResourceBuilder<?, Object>> builderCaller) {
            WhiteboardImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Void>(){

                protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                    ResourceBuilder builder = null;
                    Resource resource = null;
                    Model model = modelMgr.getModel(modelName);
                    if (model == null) {
                        builder = modelMgr.createModel(null, modelName).withService(serviceName).withResource(resourceName);
                    } else {
                        Service service = (Service)model.getServices().get(serviceName);
                        if (service == null) {
                            builder = model.createService(serviceName).withResource(resourceName);
                        } else {
                            resource = (Resource)service.getResources().get(resourceName);
                            if (resource == null) {
                                builder = service.createResource(resourceName);
                            }
                        }
                    }
                    if (builder != null) {
                        builderCaller.accept(builder);
                    }
                    return promiseFactory.resolved(null);
                }
            });
        }

        void makeValueResource(String modelName, String serviceName, String resourceName, Class<?> type) {
            this.makeResource(modelName, serviceName, resourceName, b -> b.withType(type).withGetter().withSetter().withGetterCache(Duration.ZERO).buildAll());
        }

        void makeActionResource(String modelName, String serviceName, String resourceName, Class<?> resultType, List<Map.Entry<String, Class<?>>> params) {
            this.makeResource(modelName, serviceName, resourceName, b -> b.withAction(params).withType(resultType).buildAll());
        }

        @Test
        void testHandlersProviderFilter() throws Throwable {
            WhiteboardGet h1 = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)1));
            WhiteboardGet h2 = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)2));
            String modelName = "wbHandlerPriority";
            String svcName = "svc";
            String rcName = "rc";
            Map<String, Object> props1 = this.makeProps(41L, "wbHandlerPriority", "svc", "rc", WhiteboardImplTest.PROVIDER_A);
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h1, props1);
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h2, this.makeProps(42L, "wbHandlerPriority", "svc", "rc", new String[0]));
            this.makeValueResource("wbHandlerPriority", "svc", "rc", Integer.class);
            WhiteboardImplTest.this.createProviders("wbHandlerPriority", "svc");
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)1, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            WhiteboardImplTest.this.thread.removeWhiteboardResourceHandler((WhiteboardHandler)h1, props1);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h1, props1);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)1, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
        }

        @Test
        void testHandlersWildcardFilter() throws Throwable {
            WhiteboardGet h1 = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)1));
            WhiteboardGet h2 = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)2));
            WhiteboardGet h3 = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)3));
            String modelName = "wbHandlerPriority";
            String svcName1 = "svc1";
            String rcName1 = "rc";
            String svcName2 = "svc2";
            String rcName2 = "test";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h1, this.makeProps(41L, "wbHandlerPriority", "svc1", "rc", new String[0]));
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h2, this.makeProps(42L, "wbHandlerPriority", "svc1", null, new String[0]));
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)h3, this.makeProps(42L, "wbHandlerPriority", null, null, new String[0]));
            this.makeValueResource("wbHandlerPriority", "svc1", "rc", Integer.class);
            this.makeValueResource("wbHandlerPriority", "svc1", "test", Integer.class);
            this.makeValueResource("wbHandlerPriority", "svc2", "rc", Integer.class);
            this.makeValueResource("wbHandlerPriority", "svc2", "test", Integer.class);
            WhiteboardImplTest.this.createProviders("wbHandlerPriority", "svc1");
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc1", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)1, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc1", "test", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc2", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)3, (Integer)((Integer)result.getValue()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_B, "svc2", "test", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)3, (Integer)((Integer)result.getValue()));
        }
    }

    @Nested
    class WhiteboardHandlerTest {
        WhiteboardHandlerTest() {
        }

        Map<String, Object> makeProps(String model, String service, String resource) {
            return Map.of("service.id", 42L, "sensiNact.whiteboard.model", model, "sensiNact.whiteboard.service", service, "sensiNact.whiteboard.resource", resource);
        }

        void makeResource(final String modelName, final String serviceName, final String resourceName, final Consumer<ResourceBuilder<?, Object>> builderCaller) {
            WhiteboardImplTest.this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Void>(){

                protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                    ResourceBuilder builder = null;
                    Resource resource = null;
                    Model model = modelMgr.getModel(modelName);
                    if (model == null) {
                        builder = modelMgr.createModel(null, modelName).withService(serviceName).withResource(resourceName);
                    } else {
                        Service service = (Service)model.getServices().get(serviceName);
                        if (service == null) {
                            builder = model.createService(serviceName).withResource(resourceName);
                        } else {
                            resource = (Resource)service.getResources().get(resourceName);
                            if (resource == null) {
                                builder = service.createResource(resourceName);
                            }
                        }
                    }
                    if (builder != null) {
                        builderCaller.accept(builder);
                    }
                    return promiseFactory.resolved(null);
                }
            });
        }

        void makeValueResource(String modelName, String serviceName, String resourceName, Class<?> type) {
            this.makeResource(modelName, serviceName, resourceName, b -> b.withType(type).withGetter().withSetter().withGetterCache(Duration.ZERO).buildAll());
        }

        void makeActionResource(String modelName, String serviceName, String resourceName, Class<?> resultType, List<Map.Entry<String, Class<?>>> params) {
            this.makeResource(modelName, serviceName, resourceName, b -> b.withAction(params).withType(resultType).buildAll());
        }

        @Test
        void testReadOnly() throws Throwable {
            WhiteboardGet getHandler = (pf, modelPackageUri, model, provider, service, resource, resourceType, cachedValue) -> pf.resolved((Object)new TimedValueImpl((Object)42));
            String modelName = "wbHandlerROTest";
            String svcName = "svc";
            String rcName = "rc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)getHandler, this.makeProps("wbHandlerROTest", "svc", "rc"));
            this.makeValueResource("wbHandlerROTest", "svc", "rc", Integer.class);
            WhiteboardImplTest.this.createProviders("wbHandlerROTest", "svc");
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)42, (Integer)((Integer)result.getValue()));
            Assertions.assertThrows(NoSuchElementException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }

        @Test
        void testReadWrite() throws Throwable {
            WhiteboardSet<Long> rcHandler = new WhiteboardSet<Long>(){
                Long value = 42L;

                public Promise<TimedValue<Long>> pullValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, Class<Long> resourceType, TimedValue<Long> cachedValue) {
                    return pf.resolved((Object)new TimedValueImpl((Object)this.value));
                }

                public Promise<TimedValue<Long>> pushValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, Class<Long> resourceType, TimedValue<Long> cachedValue, TimedValue<Long> newValue) {
                    this.value = (Long)newValue.getValue();
                    return pf.resolved((Object)new TimedValueImpl((Object)this.value));
                }
            };
            String modelName = "wbHandlerRWTest";
            String svcName = "svc";
            String rcName = "rc";
            this.makeValueResource("wbHandlerRWTest", "svc", "rc", Long.class);
            WhiteboardImplTest.this.createProviders("wbHandlerRWTest", "svc");
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)rcHandler, this.makeProps("wbHandlerRWTest", "svc", "rc"));
            TimedValue<Long> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((long)42L, (Long)((Long)result.getValue()));
            WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234L, Instant.now()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((long)1234L, (Long)((Long)result.getValue()));
            WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue(null, Instant.now()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNull((Object)result.getValue(), (String)"Value still there");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
        }

        @Test
        void testActEcho() throws Throwable {
            WhiteboardAct providerEchoHandler = (promiseFactory, modelPackageUri, model, provider, service, resource, arguments) -> promiseFactory.resolved((Object)provider);
            String modelName = "wbHandlerActTest";
            String svcName = "svc";
            String rcName = "rc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)providerEchoHandler, this.makeProps("wbHandlerActTest", "svc", "rc"));
            this.makeActionResource("wbHandlerActTest", "svc", "rc", String.class, List.of());
            WhiteboardImplTest.this.createProviders("wbHandlerActTest", "svc");
            Assertions.assertEquals((Object)WhiteboardImplTest.PROVIDER_A, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of()));
            Assertions.assertEquals((Object)WhiteboardImplTest.PROVIDER_B, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_B, "svc", "rc", Map.of()));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", String.class));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }

        @Test
        void testActArgs() throws Throwable {
            WhiteboardAct providerEchoHandler = (pf, modelPackageUri, model, provider, service, resource, arguments) -> {
                String value = (String)arguments.get("value");
                if (value == null) {
                    return pf.failed((Throwable)new NullPointerException("No value given"));
                }
                Integer radix = (Integer)arguments.get("radix");
                if (radix == null) {
                    radix = 10;
                }
                return pf.resolved((Object)Integer.parseInt(value, radix));
            };
            String modelName = "wbHandlerActTest2";
            String svcName = "svc";
            String rcName = "rc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)providerEchoHandler, this.makeProps("wbHandlerActTest2", "svc", "rc"));
            this.makeActionResource("wbHandlerActTest2", "svc", "rc", Integer.class, List.of(Map.entry("value", String.class), Map.entry("radix", Integer.class)));
            WhiteboardImplTest.this.createProviders("wbHandlerActTest2", "svc");
            Assertions.assertEquals((Object)10, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10")));
            Assertions.assertEquals((Object)10, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10", "radix", 10)));
            Assertions.assertEquals((Object)2, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10", "radix", 2)));
            Assertions.assertEquals((Object)255, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "FF", "radix", 16)));
            Assertions.assertThrows(NullPointerException.class, () -> WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of()));
            Assertions.assertThrows(NullPointerException.class, () -> WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", null)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", String.class));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }
    }

    @Nested
    class WhiteboardHandlerAutoCreateTest {
        WhiteboardHandlerAutoCreateTest() {
        }

        Map<String, Object> makeProps(String model, String service, String resource) {
            return Map.of("service.id", 42L, "sensiNact.whiteboard.model", model, "sensiNact.whiteboard.service", service, "sensiNact.whiteboard.resource", resource, "sensiNact.whiteboard.create", true);
        }

        @Test
        void testReadOnly() throws Throwable {
            AbstractDescriptiveReadOnly<Integer> getHandler = new AbstractDescriptiveReadOnly<Integer>(){

                public Promise<TimedValue<Integer>> doPullValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, TimedValue<Integer> cachedValue) {
                    return pf.resolved((Object)new TimedValueImpl((Object)42));
                }
            };
            Assertions.assertEquals(Integer.class, (Object)getHandler.getResourceType());
            String modelName = "wbHandlerROTest";
            String svcName = "svc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)getHandler, this.makeProps("wbHandlerROTest", "svc", "rc"));
            WhiteboardImplTest.this.createProviders("wbHandlerROTest", "svc");
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Integer.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)42, (Integer)((Integer)result.getValue()));
            Assertions.assertThrows(NoSuchElementException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }

        @Test
        void testReadWrite() throws Throwable {
            AbstractDescriptiveReadWrite<Long> rcHandler = new AbstractDescriptiveReadWrite<Long>(){
                Long value = 42L;

                public Promise<TimedValue<Long>> doPullValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, TimedValue<Long> cachedValue) {
                    return pf.resolved((Object)new TimedValueImpl((Object)this.value));
                }

                public Promise<TimedValue<Long>> doPushValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, TimedValue<Long> cachedValue, TimedValue<Long> newValue) {
                    this.value = (Long)newValue.getValue();
                    return pf.resolved((Object)new TimedValueImpl((Object)this.value));
                }
            };
            Assertions.assertEquals(Long.class, (Object)rcHandler.getResourceType());
            String modelName = "wbHandlerRWTest";
            String svcName = "svc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)rcHandler, this.makeProps("wbHandlerRWTest", "svc", "rc"));
            WhiteboardImplTest.this.createProviders("wbHandlerRWTest", "svc");
            TimedValue<Long> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((long)42L, (Long)((Long)result.getValue()));
            WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234L, Instant.now()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((long)1234L, (Long)((Long)result.getValue()));
            WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue(null, Instant.now()));
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Long.class);
            Assertions.assertNull((Object)result.getValue(), (String)"Value still there");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
        }

        @Test
        void testActEcho() throws Throwable {
            AbstractDescriptiveAct<String> providerEchoHandler = new AbstractDescriptiveAct<String>(){

                public List<Map.Entry<String, Class<?>>> getNamedParameterTypes() {
                    return List.of();
                }

                protected Promise<String> doAct(PromiseFactory promiseFactory, String modelPackageUri, String model, String provider, String service, String resource, Map<String, Object> arguments) {
                    return promiseFactory.resolved((Object)provider);
                }
            };
            Assertions.assertEquals(String.class, (Object)providerEchoHandler.getReturnType());
            String modelName = "wbHandlerActTest";
            String svcName = "svc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)providerEchoHandler, this.makeProps("wbHandlerActTest", "svc", "rc"));
            WhiteboardImplTest.this.createProviders("wbHandlerActTest", "svc");
            Assertions.assertEquals((Object)WhiteboardImplTest.PROVIDER_A, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of()));
            Assertions.assertEquals((Object)WhiteboardImplTest.PROVIDER_B, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_B, "svc", "rc", Map.of()));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", String.class));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }

        @Test
        void testActArgs() throws Throwable {
            AbstractDescriptiveAct<Integer> providerEchoHandler = new AbstractDescriptiveAct<Integer>(){

                public List<Map.Entry<String, Class<?>>> getNamedParameterTypes() {
                    return List.of(Map.entry("value", String.class), Map.entry("radix", Integer.class));
                }

                public Promise<Integer> doAct(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, Map<String, Object> arguments) {
                    String value = (String)arguments.get("value");
                    if (value == null) {
                        return pf.failed((Throwable)new NullPointerException("No value given"));
                    }
                    Integer radix = (Integer)arguments.get("radix");
                    if (radix == null) {
                        radix = 10;
                    }
                    return pf.resolved((Object)Integer.parseInt(value, radix));
                }
            };
            String modelName = "wbHandlerActTest2";
            String svcName = "svc";
            WhiteboardImplTest.this.thread.addWhiteboardResourceHandler((WhiteboardHandler)providerEchoHandler, this.makeProps("wbHandlerActTest2", "svc", "rc"));
            WhiteboardImplTest.this.createProviders("wbHandlerActTest2", "svc");
            Assertions.assertEquals((Object)10, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10")));
            Assertions.assertEquals((Object)10, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10", "radix", 10)));
            Assertions.assertEquals((Object)2, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "10", "radix", 2)));
            Assertions.assertEquals((Object)255, (Object)WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", "FF", "radix", 16)));
            Assertions.assertThrows(NullPointerException.class, () -> WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of()));
            Assertions.assertThrows(NullPointerException.class, () -> WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, "svc", "rc", Map.of("value", null)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", String.class));
            Assertions.assertThrows(IllegalArgumentException.class, () -> WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", "rc", r -> r.setValue((Object)1234, Instant.now())));
        }
    }

    @Nested
    class TwoPullBasedResourceTest {
        TwoPullBasedResourceTest() {
        }

        @Test
        void testPushPull() throws Throwable {
            TwoPullResourceTest resourceProvider = new TwoPullResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 259L, "sensiNact.whiteboard.resource", true));
            String svc = "buzz";
            WhiteboardImplTest.this.createProviders("fizz", "buzz");
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "buzz", "version", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "buzz", "count", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            TimedValue<String> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "buzz", "version", String.class);
            Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((Object)"1.0.0", (Object)result.getValue());
            TimedValue<Integer> result2 = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "buzz", "count", Integer.class);
            Assertions.assertNotNull((Object)result2.getValue(), (String)"No value");
            Assertions.assertNotNull((Object)result2.getTimestamp(), (String)"No timestamp");
            Assertions.assertEquals((int)42, (Integer)((Integer)result2.getValue()));
        }
    }

    public static class TwoPullResourceTest {
        @GET(model="fizz", service="buzz", resource="version")
        public String version() {
            return "1.0.0";
        }

        @GET(model="fizz", service="buzz", resource="count")
        public Integer count() {
            return 42;
        }
    }

    @Nested
    class PushPullBasedResourceTest {
        PushPullBasedResourceTest() {
        }

        @Test
        void testPushPull() throws Throwable {
            PullPushResourceTest resourceProvider = new PullPushResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 258L, "sensiNact.whiteboard.resource", true));
            String svc = "svc";
            WhiteboardImplTest.this.createProviders("foobar", "svc");
            for (String rc : List.of("a", "b")) {
                WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "svc", rc, r -> {
                    Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                    return null;
                });
                TimedValue<Content> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", rc, Content.class);
                Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
                Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp");
                Assertions.assertNull((Object)((Content)result.getValue()).oldValue);
                Assertions.assertEquals((Object)rc, (Object)((Content)result.getValue()).newValue);
                Instant setTimestamp = Instant.now().plus(Duration.ofMinutes(5L));
                WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", rc, r -> r.setValue((Object)"toto", setTimestamp));
                result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", rc, Content.class, GetLevel.STRONG);
                Assertions.assertNotNull((Object)result.getValue(), (String)"No value");
                Assertions.assertEquals((Object)setTimestamp, (Object)result.getTimestamp());
                Assertions.assertEquals((Object)"toto", (Object)((Content)result.getValue()).oldValue);
                Assertions.assertEquals((Object)"+toto", (Object)((Content)result.getValue()).newValue);
                Instant setTimestamp2 = Instant.now().plus(Duration.ofMinutes(10L));
                WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "svc", rc, r -> r.setValue((Object)"titi", setTimestamp2));
                result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "svc", rc, Content.class, GetLevel.STRONG);
                Assertions.assertEquals((Object)setTimestamp2, (Object)result.getTimestamp());
                Assertions.assertEquals((Object)"titi", (Object)((Content)result.getValue()).oldValue);
                Assertions.assertEquals((Object)"+titi", (Object)((Content)result.getValue()).newValue);
            }
        }
    }

    public static class PullPushResourceTest {
        @GET.GETs(value={@GET(model="foobar", service="svc", resource="a", type=Content.class), @GET(model="foobar", service="svc", resource="b", type=Content.class)})
        public TimedValue<Content> doGet(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource, @GetParam(value=GetParam.GetSegment.CACHED_VALUE) TimedValue<Content> cached) {
            Content content = new Content();
            Content oldContent = (Content)cached.getValue();
            if (oldContent != null) {
                content.oldValue = oldContent.newValue;
                content.newValue = "+" + oldContent.newValue;
            } else {
                content.oldValue = null;
                content.newValue = resource;
            }
            return new TimedValueImpl((Object)content, cached.getTimestamp() == null ? Instant.now() : cached.getTimestamp());
        }

        @SET.SETs(value={@SET(model="foobar", service="svc", resource="a", type=Content.class), @SET(model="foobar", service="svc", resource="b", type=Content.class)})
        public TimedValue<Content> doSet(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource, @SetParam(value=SetParam.SetSegment.CACHED_VALUE) TimedValue<Content> cached, @SetParam(value=SetParam.SetSegment.NEW_VALUE) TimedValue<String> newValue) {
            Content content = new Content();
            content.oldValue = cached.getValue() != null ? ((Content)cached.getValue()).newValue : null;
            content.newValue = (String)newValue.getValue();
            return new TimedValueImpl((Object)content, newValue.getTimestamp());
        }
    }

    static class Content {
        String oldValue;
        String newValue;

        Content() {
        }

        public String toString() {
            return "Content(old=" + this.oldValue + " ;; new=" + this.newValue + ")";
        }
    }

    @Nested
    class PushBasedResourceTest {
        PushBasedResourceTest() {
        }

        @Test
        void testPush() throws Throwable {
            BasePushResourceTest resourceProvider = new BasePushResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 257L, "sensiNact.whiteboard.resource", true));
            String svc = "push";
            WhiteboardImplTest.this.createProviders("bar", "push");
            for (String rc : List.of("a", "b")) {
                WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "push", rc, r -> {
                    Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                    return null;
                });
                TimedValue<String> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "push", rc, String.class);
                Assertions.assertNull((Object)result.getValue());
                Assertions.assertNull((Object)result.getTimestamp());
                Instant setTimestamp = Instant.now().minus(Duration.ofMinutes(5L));
                WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "push", rc, r -> r.setValue((Object)"toto", setTimestamp));
                result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "push", rc, String.class, GetLevel.STRONG);
                Assertions.assertEquals((Object)"toto", (Object)result.getValue());
                Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
                Assertions.assertEquals((Object)setTimestamp, (Object)result.getTimestamp());
                Instant setTimestamp2 = Instant.now().minus(Duration.ofMinutes(1L));
                WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "push", rc, r -> r.setValue((Object)"titi", setTimestamp2));
                result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "push", rc, String.class, GetLevel.STRONG);
                Assertions.assertEquals((Object)"resource:toto", (Object)result.getValue());
                Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
                Assertions.assertEquals((Object)setTimestamp2, (Object)result.getTimestamp());
            }
        }
    }

    public static class BasePushResourceTest {
        @SET.SETs(value={@SET(model="bar", service="push", resource="a", type=String.class), @SET(model="bar", service="push", resource="b", type=String.class)})
        public TimedValue<String> doMultiResource(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource, @SetParam(value=SetParam.SetSegment.RESULT_TYPE) Class<?> type, @SetParam(value=SetParam.SetSegment.CACHED_VALUE) TimedValue<String> cached, @SetParam(value=SetParam.SetSegment.NEW_VALUE) TimedValue<String> newValue) {
            Object value;
            switch (resource) {
                case "a": 
                case "b": {
                    if (cached.getValue() != null) {
                        value = "resource:" + (String)cached.getValue();
                        break;
                    }
                    value = (String)newValue.getValue();
                    break;
                }
                default: {
                    value = "x";
                }
            }
            return new TimedValueImpl(value, newValue.getTimestamp());
        }
    }

    @Nested
    class PullBasedResourceTest {
        PullBasedResourceTest() {
        }

        @Test
        void testBasicPullResource() throws Throwable {
            BasePullResourceTest resourceProvider = new BasePullResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 256L, "sensiNact.whiteboard.resource", true));
            String svc = "pull";
            WhiteboardImplTest.this.createProviders("bar", "pull");
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "pull", "a", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            TimedValue<String> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "a", String.class, GetLevel.STRONG);
            Assertions.assertEquals((Object)"a", (Object)result.getValue());
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Instant initialTimestamp = result.getTimestamp();
            Thread.sleep(200L);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "a", String.class, GetLevel.STRONG);
            Assertions.assertEquals((Object)"resource:a", (Object)result.getValue());
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Instant secondTimestamp = result.getTimestamp();
            Assertions.assertTrue((boolean)secondTimestamp.isAfter(initialTimestamp), (String)(secondTimestamp + " should be after " + initialTimestamp));
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "pull", "b", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "b", String.class, GetLevel.WEAK);
            Assertions.assertNull((Object)result.getValue());
            Assertions.assertNull((Object)result.getTimestamp());
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "b", String.class, GetLevel.NORMAL);
            Assertions.assertNull((Object)result.getValue());
            Assertions.assertNull((Object)result.getTimestamp());
            resourceProvider.bReturnNull = false;
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "b", String.class, GetLevel.STRONG);
            Assertions.assertEquals((Object)"b", (Object)result.getValue());
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            initialTimestamp = result.getTimestamp();
            Thread.sleep(200L);
            resourceProvider.bReturnNull = true;
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "b", String.class, GetLevel.STRONG);
            Assertions.assertEquals(null, (Object)result.getValue());
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            secondTimestamp = result.getTimestamp();
            Assertions.assertTrue((boolean)secondTimestamp.isAfter(initialTimestamp), (String)(secondTimestamp + " should be after " + initialTimestamp));
        }

        @Test
        void testCachedPullResource() throws Throwable {
            CachedPullResourceTest resourceProvider = new CachedPullResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 256L, "sensiNact.whiteboard.resource", true));
            String svc = "pull";
            WhiteboardImplTest.this.createProviders("bar", "pull");
            String rc = "cache";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "pull", "cache", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.NORMAL);
            Assertions.assertEquals((int)1, (Integer)((Integer)result.getValue()));
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Instant initialTimestamp = result.getTimestamp();
            Thread.sleep(200L);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.NORMAL);
            Assertions.assertEquals((int)1, (Integer)((Integer)result.getValue()));
            Assertions.assertEquals((Object)initialTimestamp, (Object)result.getTimestamp());
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.STRONG);
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            Instant secondTimestamp = result.getTimestamp();
            Assertions.assertTrue((boolean)initialTimestamp.isBefore(secondTimestamp), (String)"Timestamp wasn't updated");
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.WEAK);
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            Assertions.assertEquals((Object)secondTimestamp, (Object)result.getTimestamp());
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.NORMAL);
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            Assertions.assertEquals((Object)secondTimestamp, (Object)result.getTimestamp());
            Thread.sleep(1200L);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.WEAK);
            Assertions.assertEquals((int)2, (Integer)((Integer)result.getValue()));
            Assertions.assertEquals((Object)secondTimestamp, (Object)result.getTimestamp());
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "cache", Integer.class, GetLevel.NORMAL);
            Assertions.assertEquals((int)4, (Integer)((Integer)result.getValue()));
            Assertions.assertTrue((boolean)secondTimestamp.isBefore(result.getTimestamp()), (String)"Timestamp wasn't updated");
        }

        @Test
        void testForcedInitialValue() throws Throwable {
            CachedPullResourceTest resourceProvider = new CachedPullResourceTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)resourceProvider, Map.of("service.id", 256L, "sensiNact.whiteboard.resource", true));
            String svc = "pull";
            WhiteboardImplTest.this.createProviders("bar", "pull");
            String rc = "forced-cache";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, "pull", "forced-cache", r -> {
                Assertions.assertThrows(IllegalArgumentException.class, () -> r.getArguments());
                return null;
            });
            Instant initialTimesamp = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            WhiteboardImplTest.this.setValue(WhiteboardImplTest.PROVIDER_A, "pull", "forced-cache", r -> r.setValue((Object)42, initialTimesamp));
            TimedValue<Integer> result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "forced-cache", Integer.class, GetLevel.WEAK);
            Assertions.assertEquals((int)42, (Integer)((Integer)result.getValue()));
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Assertions.assertEquals((Object)initialTimesamp, (Object)result.getTimestamp());
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "forced-cache", Integer.class, GetLevel.NORMAL);
            Assertions.assertEquals((int)42, (Integer)((Integer)result.getValue()));
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Assertions.assertEquals((Object)initialTimesamp, (Object)result.getTimestamp());
            Thread.sleep(110L);
            result = WhiteboardImplTest.this.getValue(WhiteboardImplTest.PROVIDER_A, "pull", "forced-cache", Integer.class, GetLevel.STRONG);
            Assertions.assertEquals((int)84, (Integer)((Integer)result.getValue()));
            Assertions.assertNotNull((Object)result.getTimestamp(), (String)"No timestamp returned");
            Assertions.assertTrue((boolean)initialTimesamp.isBefore(result.getTimestamp()), (String)"Timestamp not updated");
        }
    }

    public static class CachedPullResourceTest {
        @GET.GETs(value={@GET(model="bar", service="pull", resource="cache", cacheDuration=1L, cacheDurationUnit=ChronoUnit.SECONDS), @GET(model="bar", service="pull", resource="forced-cache", cacheDuration=1L, cacheDurationUnit=ChronoUnit.SECONDS)})
        public Integer doCachedResource(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource, @GetParam(value=GetParam.GetSegment.RESULT_TYPE) Class<?> type, @GetParam(value=GetParam.GetSegment.CACHED_VALUE) TimedValue<?> cached) {
            if (cached.getValue() == null) {
                return 1;
            }
            return (Integer)cached.getValue() * 2;
        }
    }

    public static class BasePullResourceTest {
        public boolean bReturnNull = true;

        @GET.GETs(value={@GET(model="bar", service="pull", resource="a"), @GET(model="bar", service="pull", resource="b", onNull=NullAction.UPDATE_IF_PRESENT)})
        public String doMultiResource(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource, @GetParam(value=GetParam.GetSegment.RESULT_TYPE) Class<?> type, @GetParam(value=GetParam.GetSegment.CACHED_VALUE) TimedValue<?> cached) {
            switch (resource) {
                case "b": {
                    if (this.bReturnNull) {
                        return null;
                    }
                }
                case "a": {
                    if (cached.getValue() != null) {
                        return "resource:" + cached.getValue();
                    }
                    return resource;
                }
            }
            return "x";
        }
    }

    @Nested
    class ActionTests {
        ActionTests() {
        }

        @Test
        void testAddActionResource() throws Throwable {
            ExtendedActionTest actionProvider = new ExtendedActionTest();
            WhiteboardImplTest.this.thread.addWhiteboardService((Object)actionProvider, Map.of("service.id", 42L, "sensiNact.whiteboard.resource", true));
            String svc = "actions";
            WhiteboardImplTest.this.createProviders("foo", svc);
            String rc = "1";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(), (Object)r.getArguments());
                return null;
            });
            Object result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of());
            Assertions.assertEquals((Object)Byte.valueOf("1"), (Object)result);
            rc = "2";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(new AbstractMap.SimpleEntry<String, Class<String>>("arg0", String.class)), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of("arg0", 16));
            Assertions.assertEquals((Object)Short.valueOf("32"), (Object)result);
            rc = "3";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(new AbstractMap.SimpleEntry<String, Class<Integer>>("arg1", Integer.class), new AbstractMap.SimpleEntry<String, Class<Instant>>("arg0", Instant.class)), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of("arg1", "5", "arg0", Instant.now().plusSeconds(60L)));
            Assertions.assertEquals((Object)Integer.valueOf("15"), (Object)result);
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of("arg1", "5", "arg0", Instant.now().minusSeconds(60L)));
            Assertions.assertEquals((Object)Integer.valueOf("25"), (Object)result);
            rc = "4";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(new AbstractMap.SimpleEntry<String, Class<Byte>>("arg0", Byte.class), new AbstractMap.SimpleEntry<String, Class<Integer>>("arg2", Integer.class)), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of("arg0", 7, "arg2", 2));
            Assertions.assertEquals((Object)Double.valueOf("56"), (Object)result);
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_B, svc, rc, r -> {
                Assertions.assertEquals(List.of(new AbstractMap.SimpleEntry<String, Class<Byte>>("arg0", Byte.class), new AbstractMap.SimpleEntry<String, Class<Integer>>("arg2", Integer.class)), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_B, svc, rc, Map.of("arg0", 7, "arg2", 2));
            Assertions.assertEquals((double)Double.valueOf("61.6"), (double)((Double)result), (double)1.0E-7);
            svc = "multi-actions";
            rc = "a";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of());
            Assertions.assertEquals((Object)"a", (Object)result);
            rc = "b";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of());
            Assertions.assertEquals((Object)"b", (Object)result);
            rc = "c";
            WhiteboardImplTest.this.runRcCommand(WhiteboardImplTest.PROVIDER_A, svc, rc, r -> {
                Assertions.assertEquals(List.of(), (Object)r.getArguments());
                return null;
            });
            result = WhiteboardImplTest.this.act(WhiteboardImplTest.PROVIDER_A, svc, rc, Map.of());
            Assertions.assertEquals((Object)"c", (Object)result);
        }
    }

    public static class ExtendedActionTest
    extends BaseActionTest {
        @ACT.ACTs(value={@ACT(model="foo", service="multi-actions", resource="a"), @ACT(model="foo", service="multi-actions", resource="b"), @ACT(model="foo", service="multi-actions", resource="c")})
        public String doMultiAction(@UriParam(value=UriParam.UriSegment.RESOURCE) String resource) {
            switch (resource) {
                case "a": 
                case "b": 
                case "c": {
                    return resource;
                }
            }
            return "x";
        }
    }

    public static abstract class BaseActionTest {
        @ACT(model="foo", service="actions", resource="1")
        public byte noArgs() {
            return 1;
        }

        @ACT(model="foo", service="actions", resource="2")
        public Short stringArg(String arg0) {
            return (short)(2 * Short.valueOf(arg0));
        }

        @ACT(model="foo", service="actions", resource="3")
        public Integer namedArgs(@ActParam(value="arg1") Integer arg0, @ActParam(value="arg0") Instant arg1) {
            return (arg1.isAfter(Instant.now()) ? 3 : 5) * arg0;
        }

        @ACT(model="foo", service="actions", resource="4")
        public Double uriArgs(Byte arg0, @UriParam(value=UriParam.UriSegment.PROVIDER) String arg1, Integer arg2) {
            switch (arg1) {
                case "providerA": {
                    return 4.0 * arg0.doubleValue() * arg2.doubleValue();
                }
                case "providerB": {
                    return 4.4 * arg0.doubleValue() * arg2.doubleValue();
                }
            }
            return -4.0;
        }
    }
}

