/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.emf.util;

import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.GeoJsonType;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EMFUtilTest {
    @Test
    void testConvertStringToGeoJson() {
        String point = "{\"type\": \"Point\", \"coordinates\": [12.3,45.6]}";
        Point o = (Point)EMFUtil.convertToTargetType(GeoJsonObject.class, (Object)point);
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)o.type);
        Assertions.assertEquals((double)12.3, (double)o.coordinates.longitude);
        Assertions.assertEquals((double)45.6, (double)o.coordinates.latitude);
        o = (Point)EMFUtil.convertToTargetType((EClassifier)ProviderPackage.eINSTANCE.getEGeoJsonObject(), (Object)point);
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)o.type);
        Assertions.assertEquals((double)12.3, (double)o.coordinates.longitude);
        Assertions.assertEquals((double)45.6, (double)o.coordinates.latitude);
    }

    @Test
    void testConvertMapToGeoJson() {
        Map<String, double[]> point = Map.of("type", "Point", "coordinates", new double[]{12.3, 45.6});
        Point o = (Point)EMFUtil.convertToTargetType(GeoJsonObject.class, point);
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)o.type);
        Assertions.assertEquals((double)12.3, (double)o.coordinates.longitude);
        Assertions.assertEquals((double)45.6, (double)o.coordinates.latitude);
        o = (Point)EMFUtil.convertToTargetType((EClassifier)ProviderPackage.eINSTANCE.getEGeoJsonObject(), point);
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)o.type);
        Assertions.assertEquals((double)12.3, (double)o.coordinates.longitude);
        Assertions.assertEquals((double)45.6, (double)o.coordinates.latitude);
    }

    @Test
    void testConvertStringToNumber() {
        String num = "12";
        Number o = (Number)EMFUtil.convertToTargetType(Integer.class, (Object)num);
        Assertions.assertEquals((Object)12, (Object)o);
        o = (Number)EMFUtil.convertToTargetType((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), (Object)num);
        Assertions.assertEquals((Object)12, (Object)o);
    }
}

