/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sensinact.core.annotation.dto.Data;
import org.eclipse.sensinact.core.annotation.dto.DuplicateAction;
import org.eclipse.sensinact.core.annotation.dto.Metadata;
import org.eclipse.sensinact.core.annotation.dto.Model;
import org.eclipse.sensinact.core.annotation.dto.ModelPackageUri;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.dto.Provider;
import org.eclipse.sensinact.core.annotation.dto.Resource;
import org.eclipse.sensinact.core.annotation.dto.Service;
import org.eclipse.sensinact.core.annotation.dto.Timestamp;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.FailedMappingDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.CustomDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.model.core.testdata.TestdataPackage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AnnotationBasedDtoExtractorTest {
    private static final String MODEL_PACKAGE_URI = "http://test.org/foo/bar";
    private static final String MODEL = "model";
    private static final String PROVIDER = "provider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final String RESOURCE_2 = "resource2";
    private static final Integer VALUE = 5;
    private static final String VALUE_2 = "Fourteen";
    private static final String METADATA_KEY = "foo";
    private static final String METADATA_VALUE = "fizz";
    private static final String METADATA_VALUE_2 = "buzz";

    DataExtractor extractor(Class<?> clazz) {
        return new CustomDtoDataExtractor(clazz);
    }

    private void checkCommonFields(AbstractUpdateDto extracted) {
        this.checkCommonFields(extracted, true);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, Instant time) {
        this.checkCommonFields(extracted, true, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, String altResource, Instant time) {
        this.checkCommonFields(extracted, true, altResource, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1) {
        this.checkCommonFields(extracted, use1, null);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1, Instant time) {
        this.checkCommonFields(extracted, use1, null, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1, String altResource, Instant time) {
        Assertions.assertEquals((Object)PROVIDER, (Object)extracted.provider);
        Assertions.assertEquals((Object)SERVICE, (Object)extracted.service);
        Assertions.assertEquals((Object)(altResource == null ? (use1 ? RESOURCE : RESOURCE_2) : altResource), (Object)extracted.resource);
        if (time == null) {
            Assertions.assertTrue((boolean)Duration.between(extracted.timestamp, Instant.now()).minusMillis(100L).isNegative(), () -> "The timestamp was not set properly got: " + extracted.timestamp + " now is: " + Instant.now());
        } else {
            Assertions.assertEquals((Object)time, (Object)extracted.timestamp);
        }
    }

    @Nested
    public class EMFAnnotated {
        @Test
        void basicDtoWithServiceReference() {
            EMFTestDto dto = new EMFTestDto();
            dto.v1 = AnnotationBasedDtoExtractorTest.VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(EMFTestDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            DataUpdateDto extracted = updates.stream().findFirst().map(DataUpdateDto.class::cast).get();
            Assertions.assertEquals((Object)TestdataPackage.Literals.TEST_SENSOR, (Object)extracted.modelEClass);
            Assertions.assertEquals((Object)TestdataPackage.Literals.TEST_SENSOR__TEMP, (Object)extracted.serviceReference);
        }

        @Test
        void dtoWithDynamicProviderAndServiceEClass() {
            EMFTestDynamicDto dto = new EMFTestDynamicDto();
            dto.v1 = AnnotationBasedDtoExtractorTest.VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(EMFTestDynamicDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            DataUpdateDto extracted = updates.stream().findFirst().map(DataUpdateDto.class::cast).get();
            Assertions.assertEquals((Object)TestdataPackage.Literals.DYNAMIC_TEST_SENSOR, (Object)extracted.modelEClass);
            Assertions.assertEquals((Object)TestdataPackage.Literals.TEST_TEMPERATUR, (Object)extracted.serviceEClass);
            Assertions.assertEquals((Object)"humidity", (Object)extracted.service);
            Assertions.assertEquals((Object)"v1", (Object)extracted.resource);
        }

        @Test
        void differentServiceNames() {
            EMFTestDifferentNameDto dto = new EMFTestDifferentNameDto();
            dto.v1 = AnnotationBasedDtoExtractorTest.VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(EMFTestDifferentNameDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            FailedMappingDto extracted = updates.stream().findFirst().map(FailedMappingDto.class::cast).get();
            Assertions.assertNotNull((Object)extracted.mappingFailure);
            Assertions.assertEquals((Object)("The defined service name not_temp does not match the defined EReference temp for the field v1 in " + EMFTestDifferentNameDto.class), (Object)extracted.mappingFailure.getMessage());
        }

        @Test
        void dynamicProviderWithMissingService() {
            EMFTestDynamicFailDto dto = new EMFTestDynamicFailDto();
            dto.v1 = AnnotationBasedDtoExtractorTest.VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(EMFTestDynamicFailDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            FailedMappingDto extracted = updates.stream().findFirst().map(FailedMappingDto.class::cast).get();
            Assertions.assertNotNull((Object)extracted.mappingFailure);
            Assertions.assertEquals((Object)("No service or service EReference is defined for the field v1 in " + EMFTestDynamicFailDto.class), (Object)extracted.mappingFailure.getMessage());
        }

        @Provider(value="provider")
        public class EMFTestDto {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Service
            public EReference service = TestdataPackage.Literals.TEST_SENSOR__TEMP;
            @Service
            public EClass serviceEClass = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Data
            public String v1;
        }

        @Provider(value="provider")
        public class EMFTestDynamicDto {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.DYNAMIC_TEST_SENSOR;
            @Service
            public EClass serviceEClass = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Service
            public String serviceName = "humidity";
            @Data
            public String v1;
        }

        @Provider(value="provider")
        public class EMFTestDifferentNameDto {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Service
            public EReference service = TestdataPackage.Literals.TEST_SENSOR__TEMP;
            @Service
            public EClass serviceEClass = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Data
            @Service(value="not_temp")
            public String v1;
        }

        @Provider(value="provider")
        public class EMFTestDynamicFailDto {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.DYNAMIC_TEST_SENSOR;
            @Service
            public EClass serviceEClass = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Data
            public String v1;
        }
    }

    @Nested
    public class FieldNameDefaulting {
        @Test
        void basicDtoOneValueNullMetadata() {
            Instant time = Instant.now().minus(Duration.ofDays(3L)).truncatedTo(ChronoUnit.MILLIS);
            BasicDtoFieldNames dto = new BasicDtoFieldNames();
            dto.provider = AnnotationBasedDtoExtractorTest.PROVIDER;
            dto.service = AnnotationBasedDtoExtractorTest.SERVICE;
            dto.time = time.toEpochMilli();
            dto.foo = VALUE;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoFieldNames.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, AnnotationBasedDtoExtractorTest.METADATA_KEY, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void basicDtoWithBothValuesAndMetadataValues() {
            Instant time = Instant.now().minus(Duration.ofDays(3L)).truncatedTo(ChronoUnit.MILLIS);
            BasicDtoFieldNames dto = new BasicDtoFieldNames();
            dto.provider = AnnotationBasedDtoExtractorTest.PROVIDER;
            dto.service = AnnotationBasedDtoExtractorTest.SERVICE;
            dto.time = time.toEpochMilli();
            dto.foo = VALUE;
            dto.bar = AnnotationBasedDtoExtractorTest.VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoFieldNames.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)2, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.METADATA_KEY.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, AnnotationBasedDtoExtractorTest.METADATA_KEY, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> "bar".equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, "bar", time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)AnnotationBasedDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
        }

        @Test
        void mixedLevelAnnotationsAndOverrides() {
            MixedDefaultAndOverridden dto = new MixedDefaultAndOverridden();
            dto.foo = VALUE;
            dto.resource = Integer.toBinaryString(VALUE);
            dto.resource2 = AnnotationBasedDtoExtractorTest.VALUE_2;
            dto.units = AnnotationBasedDtoExtractorTest.METADATA_VALUE;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(MixedDefaultAndOverridden.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)4, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.METADATA_KEY.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, AnnotationBasedDtoExtractorTest.METADATA_KEY, null);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.RESOURCE.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)"101", (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.RESOURCE_2.equals(d.resource)).findFirst().get();
            Assertions.assertEquals((Object)"override", (Object)extracted.service);
            extracted.service = AnnotationBasedDtoExtractorTest.SERVICE;
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, false);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)AnnotationBasedDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.RESOURCE.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto mud = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Map.of("units", AnnotationBasedDtoExtractorTest.METADATA_VALUE), (Object)mud.metadata);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)mud.actionOnDuplicate);
        }
    }

    @Nested
    public class FieldLevelAnnotations {
        @Test
        void basicDtoOneValueNullMetadata() {
            Instant time = Instant.now().minus(Duration.ofDays(3L)).truncatedTo(ChronoUnit.MILLIS);
            BasicDtoFieldAnnotated dto = new BasicDtoFieldAnnotated();
            dto.provider = AnnotationBasedDtoExtractorTest.PROVIDER;
            dto.service = AnnotationBasedDtoExtractorTest.SERVICE;
            dto.time = time.toEpochMilli();
            dto.foo = VALUE;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoFieldAnnotated.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void basicDtoWithBothValuesAndMetadataValues() {
            Instant time = Instant.now().minus(Duration.ofDays(3L)).truncatedTo(ChronoUnit.MILLIS);
            BasicDtoFieldAnnotated dto = new BasicDtoFieldAnnotated();
            dto.provider = AnnotationBasedDtoExtractorTest.PROVIDER;
            dto.service = AnnotationBasedDtoExtractorTest.SERVICE;
            dto.time = time.toEpochMilli();
            dto.foo = VALUE;
            dto.bar = AnnotationBasedDtoExtractorTest.VALUE_2;
            dto.fizzbuzz = AnnotationBasedDtoExtractorTest.METADATA_VALUE;
            dto.units = AnnotationBasedDtoExtractorTest.METADATA_VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoFieldAnnotated.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)4, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.RESOURCE.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> AnnotationBasedDtoExtractorTest.RESOURCE_2.equals(d.resource)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, false, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)AnnotationBasedDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> ((MetadataUpdateDto)d).metadata.containsKey(AnnotationBasedDtoExtractorTest.METADATA_KEY)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, false, time);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(AnnotationBasedDtoExtractorTest.METADATA_KEY, AnnotationBasedDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertFalse((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud2.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> ((MetadataUpdateDto)d).metadata.containsKey("units")).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted, time);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap("units", AnnotationBasedDtoExtractorTest.METADATA_VALUE_2), (Object)dud2.metadata);
            Assertions.assertFalse((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    @Nested
    public class ClassLevelAnnotations {
        @Test
        void missingProviderName() {
            DataExtractor extractor = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoClassLevelError.class);
            List updates = extractor.getUpdates((Object)new BasicDtoClassLevel());
            Assertions.assertNotNull((Object)updates);
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto aud = (AbstractUpdateDto)updates.get(0);
            Assertions.assertNotNull((Object)aud);
            Assertions.assertInstanceOf(FailedMappingDto.class, (Object)aud);
            FailedMappingDto fmd = (FailedMappingDto)aud;
            Assertions.assertNotNull((Object)fmd.mappingFailure);
            Assertions.assertTrue((boolean)fmd.mappingFailure.getMessage().contains("not properly defined"), (String)("Wrong message: " + fmd.mappingFailure.getMessage()));
            Assertions.assertTrue((boolean)fmd.mappingFailure.getCause().getMessage().contains("annotated with Provider but that annotation has no value"), (String)("Wrong message: " + fmd.mappingFailure.getCause().getMessage()));
        }

        @Test
        void missingServiceName() {
            DataExtractor extractor = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoClassLevelError2.class);
            List updates = extractor.getUpdates((Object)new BasicDtoClassLevelError2());
            Assertions.assertNotNull((Object)updates);
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto aud = (AbstractUpdateDto)updates.get(0);
            Assertions.assertNotNull((Object)aud);
            Assertions.assertInstanceOf(FailedMappingDto.class, (Object)aud);
            FailedMappingDto fmd = (FailedMappingDto)aud;
            Assertions.assertNotNull((Object)fmd.mappingFailure);
            Assertions.assertTrue((boolean)fmd.mappingFailure.getMessage().contains("not properly defined"), (String)("Wrong message: " + fmd.mappingFailure.getMessage()));
            Assertions.assertTrue((boolean)fmd.mappingFailure.getCause().getMessage().contains("annotated with Service but that annotation has no value"), (String)("Wrong message: " + fmd.mappingFailure.getCause().getMessage()));
        }

        @Test
        void basicDtoNullMetadata() {
            BasicDtoClassLevel dto = new BasicDtoClassLevel();
            dto.foo = VALUE;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoClassLevel.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)2, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertEquals((Object)AnnotationBasedDtoExtractorTest.MODEL_PACKAGE_URI, (Object)extracted.modelPackageUri);
            Assertions.assertEquals((Object)AnnotationBasedDtoExtractorTest.MODEL, (Object)extracted.model);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(AnnotationBasedDtoExtractorTest.METADATA_KEY, null), (Object)dud2.metadata);
            Assertions.assertFalse((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud2.actionOnDuplicate);
        }

        @Test
        void basicDtoWithMetadataValues() {
            BasicDtoClassLevel dto = new BasicDtoClassLevel();
            dto.foo = VALUE;
            dto.fizzbuzz = AnnotationBasedDtoExtractorTest.METADATA_VALUE;
            dto.units = AnnotationBasedDtoExtractorTest.METADATA_VALUE_2;
            List updates = AnnotationBasedDtoExtractorTest.this.extractor(BasicDtoClassLevel.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)3, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> ((MetadataUpdateDto)d).metadata.containsKey(AnnotationBasedDtoExtractorTest.METADATA_KEY)).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(AnnotationBasedDtoExtractorTest.METADATA_KEY, AnnotationBasedDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertFalse((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud2.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> ((MetadataUpdateDto)d).metadata.containsKey("units")).findFirst().get();
            AnnotationBasedDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap("units", AnnotationBasedDtoExtractorTest.METADATA_VALUE_2), (Object)dud2.metadata);
            Assertions.assertFalse((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    @ModelPackageUri(value="http://test.org/foo/bar")
    @Model(value="model")
    @Provider(value="provider")
    @Service(value="service")
    public static class MixedDefaultAndOverridden {
        @Data
        public Integer foo;
        @Resource(value="resource")
        @Metadata
        public String units;
        @Data
        public String resource;
        @Service(value="override")
        @Data
        public String resource2;
    }

    public static class BasicDtoFieldNames
    extends ProviderAndServiceFields {
        @Data
        public Integer foo;
        @Data(onDuplicate=DuplicateAction.UPDATE_IF_DIFFERENT)
        public String bar;
    }

    public static class BasicDtoFieldAnnotated
    extends ProviderAndServiceFields {
        @Resource(value="resource")
        @Data
        public Integer foo;
        @Resource(value="resource2")
        @Data(onDuplicate=DuplicateAction.UPDATE_IF_DIFFERENT)
        public String bar;
        @Resource(value="resource")
        @Metadata
        public String units;
        @Resource(value="resource2")
        @Metadata(value="foo", onDuplicate=DuplicateAction.UPDATE_ALWAYS)
        public String fizzbuzz;
    }

    public static abstract class ProviderAndServiceFields {
        @Provider(value="provider")
        public String provider;
        @Service(value="service")
        public String service;
        @Timestamp
        public Long time;
    }

    @ModelPackageUri(value="http://test.org/foo/bar")
    @Model(value="model")
    @Provider(value="provider")
    @Service(value="service")
    @Resource(value="resource")
    public static class BasicDtoClassLevel {
        @Data
        public Integer foo;
        @Metadata
        public String units;
        @Metadata(value="foo", onNull=NullAction.UPDATE, onDuplicate=DuplicateAction.UPDATE_ALWAYS)
        public String fizzbuzz;
    }

    @Provider(value="provider")
    @Service
    @Resource(value="resource")
    public static class BasicDtoClassLevelError2 {
        @Data
        public Integer foo;
    }

    @Provider
    @Service(value="service")
    @Resource(value="resource")
    public static class BasicDtoClassLevelError {
        @Data
        public Integer foo;
    }
}

