/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.annotation.dto.DuplicateAction;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.FailedMappingDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.BulkGenericDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.GenericDtoDataExtractor;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class GenericDtoExtractorTest {
    private static final String PROVIDER = "provider";
    private static final String PROVIDER_2 = "provider2";
    private static final String SERVICE = "service";
    private static final String SERVICE_2 = "service2";
    private static final String RESOURCE = "resource";
    private static final String RESOURCE_2 = "resource2";
    private static final Integer VALUE = 5;
    private static final String VALUE_2 = "Fourteen";
    private static final String METADATA_KEY = "foo";
    private static final String METADATA_KEY_2 = "bar";
    private static final String METADATA_VALUE = "fizz";
    private static final Integer METADATA_VALUE_2 = 42;

    private void checkCommonFields(AbstractUpdateDto extracted) {
        this.checkCommonFields(extracted, true);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1) {
        this.checkCommonFields(extracted, use1, Instant.now(), false);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, Instant timestamp) {
        this.checkCommonFields(extracted, true, timestamp, true);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1, Instant timestamp, boolean exactTimestamp) {
        Assertions.assertEquals((Object)(use1 ? PROVIDER : PROVIDER_2), (Object)extracted.provider);
        Assertions.assertEquals((Object)(use1 ? SERVICE : SERVICE_2), (Object)extracted.service);
        Assertions.assertEquals((Object)(use1 ? RESOURCE : RESOURCE_2), (Object)extracted.resource);
        if (exactTimestamp) {
            Assertions.assertEquals((Object)extracted.timestamp, (Object)timestamp);
        } else {
            Assertions.assertTrue((boolean)Duration.between(extracted.timestamp, timestamp).minusMillis(100L).isNegative(), () -> "The timestamp was not set properly got: " + extracted.timestamp + " used was: " + timestamp);
        }
    }

    private GenericDtoDataExtractor extractor() {
        return new GenericDtoDataExtractor();
    }

    private BulkGenericDtoDataExtractor multiExtractor() {
        return new BulkGenericDtoDataExtractor();
    }

    private GenericDto makeTestDto(String provider, String service, String resource, Object data, Class<?> dataType, Map<String, Object> metadata) {
        return this.makeTestDto(provider, service, resource, data, dataType, metadata, null);
    }

    private GenericDto makeTestDto(String provider, String service, String resource, Object data, Class<?> dataType, Map<String, Object> metadata, Instant timestamp) {
        GenericDto dto = new GenericDto();
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.value = data;
        dto.type = dataType;
        dto.metadata = metadata;
        dto.timestamp = timestamp;
        return dto;
    }

    @Nested
    class BulkExtraction {
        BulkExtraction() {
        }

        @Test
        void multiValues() {
            BulkGenericDto dto = new BulkGenericDto();
            dto.dtos = List.of(GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE)), GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER_2, GenericDtoExtractorTest.SERVICE_2, GenericDtoExtractorTest.RESOURCE_2, GenericDtoExtractorTest.VALUE_2, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY_2, METADATA_VALUE_2)));
            ((GenericDto)dto.dtos.get((int)1)).duplicateDataAction = DuplicateAction.UPDATE_IF_DIFFERENT;
            ((GenericDto)dto.dtos.get((int)1)).duplicateMetadataAction = DuplicateAction.UPDATE_ALWAYS;
            List updates = GenericDtoExtractorTest.this.multiExtractor().getUpdates((Object)dto);
            Assertions.assertEquals((int)4, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> GenericDtoExtractorTest.PROVIDER.equals(d.provider)).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> GenericDtoExtractorTest.PROVIDER_2.equals(d.provider)).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted, false);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)GenericDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> GenericDtoExtractorTest.PROVIDER.equals(d.provider)).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).filter(d -> GenericDtoExtractorTest.PROVIDER_2.equals(d.provider)).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted, false);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY_2, METADATA_VALUE_2), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud2.actionOnDuplicate);
        }
    }

    @Nested
    class CombinedDataAndMetadata {
        CombinedDataAndMetadata() {
        }

        @Test
        void singleValue() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE)));
            Assertions.assertEquals((int)2, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }

        @Test
        void multiValues() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE)));
            Assertions.assertEquals((int)2, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    @Nested
    class MetaDataValues {
        MetaDataValues() {
        }

        @Test
        void singleValue() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, null, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE)));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud.metadata);
            Assertions.assertTrue((boolean)dud.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
        }

        @Test
        void multiValues() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, null, null, Map.of(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE, GenericDtoExtractorTest.METADATA_KEY_2, METADATA_VALUE_2)));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Map.of(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE, GenericDtoExtractorTest.METADATA_KEY_2, METADATA_VALUE_2), (Object)dud.metadata);
            Assertions.assertTrue((boolean)dud.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
        }

        @Test
        void nullAction() {
            GenericDto testDto = GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, null, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE));
            testDto.nullAction = NullAction.UPDATE;
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)testDto);
            Assertions.assertEquals((int)2, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            Assertions.assertEquals((Object)NullAction.UPDATE, (Object)extracted.actionOnNull);
            extracted = (AbstractUpdateDto)updates.get(1);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud.metadata);
            Assertions.assertTrue((boolean)dud.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)NullAction.UPDATE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
        }

        @Test
        void duplicateValue() {
            GenericDto testDto = GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, null, null, Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE));
            testDto.duplicateMetadataAction = DuplicateAction.UPDATE_ALWAYS;
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)testDto);
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(GenericDtoExtractorTest.METADATA_KEY, GenericDtoExtractorTest.METADATA_VALUE), (Object)dud.metadata);
            Assertions.assertTrue((boolean)dud.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }
    }

    @Nested
    class DataValues {
        DataValues() {
        }

        @Test
        void integerValue() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, null));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)NullAction.IGNORE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void integerValueWithTimestamp() {
            Instant timestamp = Instant.ofEpochMilli(1234567890L);
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, null, timestamp));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted, timestamp);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)NullAction.IGNORE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void integerValueWithLongType() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, Long.class, null));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Long.class, (Object)dud.type);
            Assertions.assertEquals((Object)NullAction.IGNORE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void stringValue() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, GenericDtoExtractorTest.VALUE_2, null, null));
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)GenericDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)NullAction.IGNORE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void nullAction() {
            GenericDto testDto = GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, GenericDtoExtractorTest.VALUE_2, null, null);
            testDto.nullAction = NullAction.UPDATE;
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)testDto);
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)GenericDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)NullAction.UPDATE, (Object)dud.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
        }

        @Test
        void duplicateAction() {
            GenericDto testDto = GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, GenericDtoExtractorTest.VALUE_2, null, null);
            testDto.duplicateDataAction = DuplicateAction.UPDATE_IF_DIFFERENT;
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)testDto);
            Assertions.assertEquals((int)1, (int)updates.size(), (String)("Wrong number of updates " + updates.size()));
            AbstractUpdateDto extracted = (AbstractUpdateDto)updates.get(0);
            GenericDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)GenericDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertNull((Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
        }
    }

    @Nested
    class MissingIdentity {
        MissingIdentity() {
        }

        @Test
        void missingProvider() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(null, GenericDtoExtractorTest.SERVICE, GenericDtoExtractorTest.RESOURCE, VALUE, null, null));
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto aud = (AbstractUpdateDto)updates.get(0);
            Assertions.assertNull((Object)aud.provider);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.SERVICE, (Object)aud.service);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.RESOURCE, (Object)aud.resource);
            Assertions.assertInstanceOf(FailedMappingDto.class, (Object)aud);
            FailedMappingDto fmd = (FailedMappingDto)aud;
            Assertions.assertNotNull((Object)fmd.mappingFailure);
            Assertions.assertTrue((boolean)fmd.mappingFailure.getMessage().contains(GenericDtoExtractorTest.PROVIDER), (String)("Wrong message: " + fmd.mappingFailure.getMessage()));
        }

        @Test
        void missingService() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, null, GenericDtoExtractorTest.RESOURCE, VALUE, null, null));
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto aud = (AbstractUpdateDto)updates.get(0);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.PROVIDER, (Object)aud.provider);
            Assertions.assertNull((Object)aud.service);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.RESOURCE, (Object)aud.resource);
            Assertions.assertInstanceOf(FailedMappingDto.class, (Object)aud);
            FailedMappingDto fmd = (FailedMappingDto)aud;
            Assertions.assertNotNull((Object)fmd.mappingFailure);
            Assertions.assertTrue((boolean)fmd.mappingFailure.getMessage().contains(GenericDtoExtractorTest.SERVICE), (String)("Wrong message: " + fmd.mappingFailure.getMessage()));
        }

        @Test
        void missingResource() {
            List updates = GenericDtoExtractorTest.this.extractor().getUpdates((Object)GenericDtoExtractorTest.this.makeTestDto(GenericDtoExtractorTest.PROVIDER, GenericDtoExtractorTest.SERVICE, null, VALUE, null, null));
            Assertions.assertEquals((int)1, (int)updates.size());
            AbstractUpdateDto aud = (AbstractUpdateDto)updates.get(0);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.PROVIDER, (Object)aud.provider);
            Assertions.assertEquals((Object)GenericDtoExtractorTest.SERVICE, (Object)aud.service);
            Assertions.assertNull((Object)aud.resource);
            Assertions.assertInstanceOf(FailedMappingDto.class, (Object)aud);
            FailedMappingDto fmd = (FailedMappingDto)aud;
            Assertions.assertNotNull((Object)fmd.mappingFailure);
            Assertions.assertTrue((boolean)fmd.mappingFailure.getMessage().contains(GenericDtoExtractorTest.RESOURCE), (String)("Wrong message: " + fmd.mappingFailure.getMessage()));
        }
    }
}

