/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.integration;

import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sensinact.core.annotation.dto.Data;
import org.eclipse.sensinact.core.annotation.dto.DuplicateAction;
import org.eclipse.sensinact.core.annotation.dto.Metadata;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.dto.Provider;
import org.eclipse.sensinact.core.annotation.dto.Resource;
import org.eclipse.sensinact.core.annotation.dto.Service;
import org.eclipse.sensinact.core.annotation.dto.Timestamp;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.DataUpdateException;
import org.eclipse.sensinact.core.push.FailedUpdatesException;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class DataUpdateServiceTest {
    private static final String PROVIDER = "DataUpdateServiceTestProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    @InjectService
    DataUpdate push;
    @InjectService
    GatewayThread gt;

    @AfterEach
    void stop(@InjectService GatewayThread gt) throws InvocationTargetException, InterruptedException {
        gt.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                Optional.ofNullable(twin.getProvider(DataUpdateServiceTest.PROVIDER)).ifPresent(SensinactProvider::delete);
                return pf.resolved(null);
            }
        }).getValue();
    }

    private Integer getResourceValue() throws Exception {
        return (Integer)this.gt.execute((AbstractSensinactCommand)new ResourceCommand<Integer>(PROVIDER, SERVICE, RESOURCE){

            protected Promise<Integer> call(SensinactResource resource, PromiseFactory pf) {
                return resource.getValue().map(t -> (Integer)t.getValue());
            }
        }).getValue();
    }

    private TimedValue<Integer> getResourceTimedValue() throws Exception {
        return (TimedValue)this.gt.execute((AbstractSensinactCommand)new ResourceCommand<TimedValue<Integer>>(PROVIDER, SERVICE, RESOURCE){

            protected Promise<TimedValue<Integer>> call(SensinactResource resource, PromiseFactory pf) {
                return resource.getValue(Integer.class);
            }
        }).getValue();
    }

    private Object getResourceMetadataValue() throws Exception {
        return this.getResourceMetadataTimedValue().getValue();
    }

    private TimedValue<Object> getResourceMetadataTimedValue() throws Exception {
        return (TimedValue)this.gt.execute((AbstractSensinactCommand)new ResourceCommand<TimedValue<Object>>(PROVIDER, SERVICE, RESOURCE){

            protected Promise<TimedValue<Object>> call(SensinactResource resource, PromiseFactory pf) {
                return resource.getMetadataValue("foo");
            }
        }).getValue();
    }

    @Nested
    class ListPushes {
        ListPushes() {
        }

        @Test
        void testEmptyList() throws Exception {
            DataUpdateServiceTest.this.push.pushUpdate(List.of()).getValue();
        }

        @Test
        void testOneItem() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate(List.of(dto)).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
        }

        @Test
        void testSeveralItems() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            AnnotatedDTO dto2 = new AnnotatedDTO();
            dto2.provider = DataUpdateServiceTest.PROVIDER;
            dto2.service = DataUpdateServiceTest.SERVICE;
            dto2.resource = DataUpdateServiceTest.RESOURCE;
            dto2.data = "43";
            dto2.time = String.valueOf(timestamp.toEpochMilli() + 1000L);
            DataUpdateServiceTest.this.push.pushUpdate(List.of(dto, dto2)).getValue();
            Assertions.assertEquals((int)43, (Integer)DataUpdateServiceTest.this.getResourceValue());
        }
    }

    @Nested
    class FailingBulkPushes {
        FailingBulkPushes() {
        }

        @Test
        void testMiddleFails() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            GenericDto dto2 = new GenericDto();
            dto2.provider = DataUpdateServiceTest.PROVIDER;
            dto2.service = DataUpdateServiceTest.SERVICE;
            dto2.resource = DataUpdateServiceTest.RESOURCE;
            dto2.value = "Forty-three";
            dto2.type = Integer.class;
            dto2.timestamp = timestamp;
            GenericDto dto3 = new GenericDto();
            dto3.provider = DataUpdateServiceTest.PROVIDER;
            dto3.service = DataUpdateServiceTest.SERVICE;
            dto3.resource = DataUpdateServiceTest.RESOURCE;
            dto3.value = "Forty-four";
            dto3.type = Integer.class;
            dto3.timestamp = timestamp;
            GenericDto dto4 = new GenericDto();
            dto4.provider = DataUpdateServiceTest.PROVIDER;
            dto4.service = DataUpdateServiceTest.SERVICE;
            dto4.resource = DataUpdateServiceTest.RESOURCE;
            dto4.value = "45";
            dto4.type = Integer.class;
            dto4.timestamp = timestamp;
            BulkGenericDto bulk = new BulkGenericDto();
            bulk.dtos = List.of(dto, dto2, dto3, dto4);
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)bulk).getFailure();
            Assertions.assertEquals((int)45, (Integer)DataUpdateServiceTest.this.getResourceValue());
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)2, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto2, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
            due = (DataUpdateException)failedUpdates.get(1);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto3, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }
    }

    @Nested
    class FailingAnnotatedPushes {
        FailingAnnotatedPushes() {
        }

        @Test
        void testProvider() throws Exception {
            Instant timestamp = Instant.now();
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = null;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.data = "42";
            dto.time = String.valueOf(timestamp.toEpochMilli());
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }

        @Test
        void testService() throws Exception {
            Instant timestamp = Instant.now();
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = null;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.data = "42";
            dto.time = String.valueOf(timestamp.toEpochMilli());
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }

        @Test
        void testResource() throws Exception {
            Instant timestamp = Instant.now();
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = null;
            dto.data = "42";
            dto.time = String.valueOf(timestamp.toEpochMilli());
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
        }

        @Test
        void testValue() throws Exception {
            Instant timestamp = Instant.now();
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.data = "Forty-two";
            dto.time = String.valueOf(timestamp.toEpochMilli());
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }

        @Test
        void testTimestamp() throws Exception {
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.data = "42";
            dto.time = "Tomorrow";
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }
    }

    @Nested
    class FailingGenericPushes {
        FailingGenericPushes() {
        }

        @Test
        void testProvider() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = null;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }

        @Test
        void testService() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = null;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }

        @Test
        void testResource() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = null;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
        }

        @Test
        void testValue() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = "0xCAFEBABE";
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            Throwable t = DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getFailure();
            Assertions.assertNotNull((Object)t);
            Assertions.assertInstanceOf(FailedUpdatesException.class, (Object)t);
            FailedUpdatesException fue = (FailedUpdatesException)t;
            List failedUpdates = fue.getFailedUpdates();
            Assertions.assertNotNull((Object)failedUpdates);
            Assertions.assertEquals((int)1, (int)failedUpdates.size());
            DataUpdateException due = (DataUpdateException)failedUpdates.get(0);
            Assertions.assertNotNull((Object)due);
            Assertions.assertSame((Object)dto, (Object)due.getOriginalDto());
            Assertions.assertEquals((Object)DataUpdateServiceTest.PROVIDER, (Object)due.getProvider());
            Assertions.assertEquals((Object)DataUpdateServiceTest.SERVICE, (Object)due.getService());
            Assertions.assertEquals((Object)DataUpdateServiceTest.RESOURCE, (Object)due.getResource());
        }
    }

    @Nested
    class ValidMetadataPushes {
        ValidMetadataPushes() {
        }

        @BeforeEach
        void setupResource() throws Exception {
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
        }

        @Test
        void testSimplePush() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.timestamp = timestamp;
            dto.metadata = Map.of("foo", "bar");
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((Object)"bar", (Object)DataUpdateServiceTest.this.getResourceMetadataValue());
        }

        @Test
        void testSimplePushUpdate() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.metadata = Map.of("foo", "bar");
            dto.timestamp = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Object> tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.timestamp = timestamp.plusSeconds(30L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.metadata = Map.of("foo", "foobar");
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"foobar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
            dto.duplicateMetadataAction = DuplicateAction.UPDATE_ALWAYS;
            dto.timestamp = timestamp.plusSeconds(60L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"foobar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp.plusSeconds(60L), (Object)tv.getTimestamp());
        }

        @Test
        void testAnnotatedPushUpdate() throws Exception {
            Instant timestamp = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            DefaultMetadataDto dto = new DefaultMetadataDto();
            dto.foo = "bar";
            dto.time = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Object> tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.time = timestamp.plusSeconds(30L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.foo = "foobar";
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"foobar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
            dto.foo = null;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"foobar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
        }

        @Test
        void testAnnotatedPushUpdateDuplicateAction() throws Exception {
            Instant timestamp = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            DuplicateMetadataDto dto = new DuplicateMetadataDto();
            dto.foo = "bar";
            dto.time = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Object> tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.time = timestamp.plusSeconds(30L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
        }

        @Test
        void testAnnotatedPushUpdateNullAction() throws Exception {
            Instant timestamp = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            NullMetadataDto dto = new NullMetadataDto();
            dto.foo = "bar";
            dto.time = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Object> tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertEquals((Object)"bar", (Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.foo = null;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceMetadataTimedValue();
            Assertions.assertNull((Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
        }
    }

    @Nested
    class ValidPushes {
        ValidPushes() {
        }

        @Test
        void testSimplePush() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
        }

        @Test
        void testSimplePushUpdate() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = null;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            dto.nullAction = NullAction.UPDATE;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Integer> tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertNull((Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.value = 42;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
            dto.value = null;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertNull((Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
        }

        @Test
        void testSimplePushUpdateIgnore() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            dto.nullAction = NullAction.IGNORE;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            dto.value = null;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
        }

        @Test
        void testSimplePushUpdateIfPresent() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = null;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            dto.nullAction = NullAction.UPDATE_IF_PRESENT;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Integer> tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertNull((Object)tv.getValue());
            Assertions.assertNull((Object)tv.getTimestamp());
            dto.value = 42;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
            dto.value = null;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertNull((Object)tv.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
        }

        @Test
        void testSimplePushAnnotated() throws Exception {
            Instant timestamp = Instant.now();
            AnnotatedDTO dto = new AnnotatedDTO();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.data = "42";
            dto.time = String.valueOf(timestamp.toEpochMilli());
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            Assertions.assertEquals((int)42, (Integer)DataUpdateServiceTest.this.getResourceValue());
        }

        @Test
        void testSimplePushUpdateDuplicateDataDifferent() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            dto.duplicateDataAction = DuplicateAction.UPDATE_IF_DIFFERENT;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Integer> tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)42, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.timestamp = timestamp.plusSeconds(30L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)42, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.value = 43;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)43, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
        }

        @Test
        void testSimplePushUpdateDuplicateDataAlways() throws Exception {
            Instant timestamp = Instant.now();
            GenericDto dto = new GenericDto();
            dto.provider = DataUpdateServiceTest.PROVIDER;
            dto.service = DataUpdateServiceTest.SERVICE;
            dto.resource = DataUpdateServiceTest.RESOURCE;
            dto.value = 42;
            dto.type = Integer.class;
            dto.timestamp = timestamp;
            dto.duplicateDataAction = DuplicateAction.UPDATE_ALWAYS;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            TimedValue<Integer> tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)42, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp, (Object)tv.getTimestamp());
            dto.timestamp = timestamp.plusSeconds(30L);
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)42, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
            dto.value = 43;
            DataUpdateServiceTest.this.push.pushUpdate((Object)dto).getValue();
            tv = DataUpdateServiceTest.this.getResourceTimedValue();
            Assertions.assertEquals((int)43, (Integer)((Integer)tv.getValue()));
            Assertions.assertEquals((Object)timestamp.plusSeconds(30L), (Object)tv.getTimestamp());
        }
    }

    public static class NullMetadataDto
    extends AnnotatedMetadataDto {
        @Metadata(onNull=NullAction.UPDATE)
        public String foo;
    }

    public static class DuplicateMetadataDto
    extends AnnotatedMetadataDto {
        @Metadata(onDuplicate=DuplicateAction.UPDATE_ALWAYS)
        public String foo;
    }

    public static class DefaultMetadataDto
    extends AnnotatedMetadataDto {
        @Metadata
        public String foo;
    }

    @Provider(value="DataUpdateServiceTestProvider")
    @Service(value="service")
    @Resource(value="resource")
    public static abstract class AnnotatedMetadataDto {
        @Timestamp
        public Instant time;
    }

    public static class AnnotatedDTO {
        @Provider
        public String provider;
        @Service
        public String service;
        @Resource
        public String resource;
        @Timestamp
        public String time;
        @Data(type=Integer.class)
        public String data;
    }
}

