/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.integration.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class AdminServiceTest {
    private static final String PROVIDER = "AdminServiceTestProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    @InjectService
    DataUpdate push;
    @InjectService
    GatewayThread gt;

    private TimedValue<?> getValue(String provider, String service, String resource) throws Exception {
        return (TimedValue)this.gt.execute((AbstractSensinactCommand)new ResourceCommand<TimedValue<?>>(provider, service, resource){

            protected Promise<TimedValue<?>> call(SensinactResource resource, PromiseFactory pf) {
                return resource.getValue();
            }
        }).getValue();
    }

    private void setValue(String provider, String service, String resource, final Object value, final Instant timestamp) throws Exception {
        this.gt.execute((AbstractSensinactCommand)new ResourceCommand<Void>(provider, service, resource){

            protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                return resource.setValue(value, timestamp);
            }
        }).getValue();
    }

    @Test
    void testAdminCreateUpdate() throws Exception {
        Instant timestamp = Instant.now();
        GenericDto dto = new GenericDto();
        dto.provider = PROVIDER;
        dto.service = SERVICE;
        dto.resource = RESOURCE;
        dto.value = 42;
        dto.type = Integer.class;
        dto.timestamp = timestamp;
        this.push.pushUpdate((Object)dto).getValue();
        TimedValue<?> descr = this.getValue(PROVIDER, "admin", "friendlyName");
        Assertions.assertEquals((Object)PROVIDER, (Object)descr.getValue());
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        descr = this.getValue(PROVIDER, "admin", "location");
        Assertions.assertNull((Object)descr.getValue());
        Assertions.assertNull((Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "friendlyName", "foo", timestamp.minusSeconds(1L));
        descr = this.getValue(PROVIDER, "admin", "friendlyName");
        Assertions.assertEquals((Object)PROVIDER, (Object)descr.getValue());
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "location", null, timestamp);
        descr = this.getValue(PROVIDER, "admin", "location");
        Assertions.assertNull((Object)descr.getValue());
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "location", "{\"type\":\"Point\",\"coordinates\":[-0.119700, 51.503300]}", timestamp.minusSeconds(1L));
        descr = this.getValue(PROVIDER, "admin", "location");
        Assertions.assertNull((Object)descr.getValue());
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "friendlyName", "foo", timestamp);
        descr = this.getValue(PROVIDER, "admin", "friendlyName");
        Assertions.assertEquals((Object)"foo", (Object)descr.getValue());
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "location", "{\"type\":\"Point\",\"coordinates\":[-0.119700, 51.503300]}", timestamp);
        descr = this.getValue(PROVIDER, "admin", "location");
        Assertions.assertEquals(Map.of("type", "Point", "coordinates", List.of(Double.valueOf(-0.1197), Double.valueOf(51.5033))), (Object)new ObjectMapper().convertValue(descr.getValue(), Map.class));
        Assertions.assertEquals((Object)timestamp, (Object)descr.getTimestamp());
        Instant future = timestamp.plusSeconds(1L);
        this.setValue(PROVIDER, "admin", "friendlyName", "eclipse", future);
        descr = this.getValue(PROVIDER, "admin", "friendlyName");
        Assertions.assertEquals((Object)"eclipse", (Object)descr.getValue());
        Assertions.assertEquals((Object)future, (Object)descr.getTimestamp());
        this.setValue(PROVIDER, "admin", "location", "{\"type\":\"Point\",\"coordinates\":[2.295049, 48.873785]}", future);
        descr = this.getValue(PROVIDER, "admin", "location");
        Assertions.assertEquals(Map.of("type", "Point", "coordinates", List.of(Double.valueOf(2.295049), Double.valueOf(48.873785))), (Object)new ObjectMapper().convertValue(descr.getValue(), Map.class));
        Assertions.assertEquals((Object)future, (Object)descr.getTimestamp());
    }
}

